// Nokia Presenter Bluetooth
// Copyright (c) 2009 sford
// Released under the MIT License: http://mbed.org/license/mit

#include "NokiaPresenter.h"

#include "mbed.h"

NokiaPresenter::NokiaPresenter(PinName tx, PinName rx, PinName rst) : _bt(tx, rx), _rst(rst) {
    printf("Setup bt module\n");
    _bt.baud(9600);
    _rst = 0;
    wait(0.5);
    _rst = 1;
    wait(0.5);

    printf("Ensure we are in AT command mode...\n");
    _bt.printf("+++");
    wait(1);
    while (_bt.readable()) {
        _bt.getc();    // empty buffer
    }

    printf("Looking for BT Module...\n");
    at("AT\r", "\r\nOK\r\n");

    printf("Reset factory settings...\n");
    at("AT&F\r", "\r\nOK\r\n");

    printf("Setting name...\n");
    at("AT+BTLNM=\"simon\"\r", "\r\nOK\r\n");

    printf("Allow connections...\n");
    at("AT+BTAUT=1, 0\r", "\r\nOK\r\n");

    printf("Start BT server...\n");
    at("AT+BTSRV=1\r", "\r\nOK\r\n");

    printf("Waiting for presenter connection...\n");
    char buffer[23];
    for (int i=0; i<21; i++) {
        buffer[i] = _bt.getc();
    }

    printf("Got request, starting handshake...\n");
    for (int i=0; i<21; i++) {
        _bt.putc(buffer[i]);
    }
    for (int i=0; i<3; i++) {
        buffer[i] = _bt.getc();
    }
    const char connect[27] = {0x05,0x18,0x00,0x01,0x10,0x01,0x02,0x00,0xFF,0xFF,0x00,0x44,0x00,0x65,0x00,0x73,0x00,0x6B,0x00,0x74,0x00,0x6F,0x00,0x70,0x00,0x00,0x00};
    for (int i=0; i<27; i++) {
        _bt.putc(connect[i]);
    }

    printf("Handshake complete, waiting for desktop request...\n");
    for (int i=0; i<23; i++) {
        buffer[i] = _bt.getc();
    }
    for (int i=0; i<23; i++) {
        _bt.putc(buffer[i]);
    }

    printf("Presenter connection all setup!\n");
}

char NokiaPresenter::key() {
    char buffer[6];
    for (int i=0; i<6; i++) {
        buffer[i] = _bt.getc();
    }

    if (buffer[3] == 0x01) {
        return 0x00; // keyup
    }
    if (buffer[5] == 0xF8) {
        switch (buffer[4]) {
            case 0x07:
                return 'L';
            case 0x08:
                return 'R';
            case 0x09:
                return 'U';
            case 0x0A:
                return 'D';
            case 0x45:
                return 'C';
        }
    }
    return buffer[4];
}

void NokiaPresenter::at(char *command, char *response) {
    _bt.printf(command);
    for (int i=0; i<strlen(response); i++) {
        if (_bt.getc() != response[i]) {
            error("AT Command [%s] Failed", command);
        }
    }
}
