// Sumo Robot control via Bluetooth/Nokia Presenter
// Copyright (c) 2009 sford
// Released under the MIT License: http://mbed.org/license/mit
 
#include "mbed.h"
#include "Motor.h"
#include "NokiaPresenter.h"

Motor left(p23, p6, p5);  // pwm, fwd, rev
Motor right(p24, p8, p7); // pwm, fwd, rev

BusOut leds(LED1, LED2, LED3, LED4);

int main() {
    leds = 1;
    NokiaPresenter nokia(p28, p27, p29); // tx, rx, rst    
    leds = 2;
    
    while(1) {    
        switch(nokia.key()) {
            case 0: 
                left.speed(0.0); 
                right.speed(0.0);
                leds = 0;
                break;
            case 'U':
                left.speed(1.0);
                right.speed(1.0);
                leds = 1 << 0 | 1 << 2;
                break;
            case 'D':
                left.speed(-1.0);
                right.speed(-1.0);
                leds = 1 << 1 | 1 << 3;
                break;
            case 'L':
                left.speed(-1.0);
                right.speed(1.0);
                leds = 1 << 1 | 1 << 2;
                break;
            case 'R':
                left.speed(1.0);
                right.speed(-1.0);
                leds = 1 << 0 | 1 << 3;
                break;
        }
    }
}
