#include "mbed.h"
#include <DotStar.h>
#define LED_NUM 20

#define ALICEBLUE 0xF0F8FF
#define ANTIQUEWHITE 0xFAEBD7
#define AQUA 0x00FFFF
 
DigitalOut led(LED1);
 
void led_Blink(Adafruit_DotStar* leds, uint8_t Nr, uint32_t Color, uint8_t WaitTime_ms);
void led_off(Adafruit_DotStar* leds);

int main() {
        Adafruit_DotStar leds( LED_NUM, PC_12, PC_10, DOTSTAR_RGB );  
      
        led_off(&leds);
    
        led_Blink(&leds, 3, ALICEBLUE, 100);
        printf("Finished\n\r");
}

// Blinken des ganzen LED Streifens
void led_Blink(Adafruit_DotStar* leds, uint8_t Nr, uint32_t Color, uint8_t WaitTime_ms)
{   
    Nr = Nr * 2;
    uint8_t i = 1;
    uint32_t j = 0;
    while(i <= Nr+1){
        if (i%2){
            while (j < LED_NUM){
                leds->setPixelColor(j, AQUA);
                j++;
            }
            j = 0;
        }
        else if (!(i%2)){
            while (j < LED_NUM){
                leds->setPixelColor(j, Color);
                j++;
            }
            j = 0;
        }
        leds->show();
        wait_ms(WaitTime_ms);
        i++;
    }
}

void led_off(Adafruit_DotStar* leds)
{ 
    uint32_t j = 0;
    while (j < LED_NUM){
        leds->setPixelColor(j, AQUA);
        j++;
    }
    leds->show();
}