#include "mbed.h"
#include "mbed_events.h"
#include "MPU9250.h"

#define SAMPLE_TIME 100

DigitalOut led1(LED1);
InterruptIn sw(USER_BUTTON);


// Sensor Interrupts
InterruptIn button1(D2);
InterruptIn button2(D3);
InterruptIn button3(D4);
InterruptIn button4(D5);
InterruptIn ir1(D6);


Thread eventthread;
Thread imuthread;
bool read_imu_isrunning;

// Pin defines
DigitalOut led_green(D4);

Serial* pc;
MPU9250* mpu9250;


void button1Event()
{
    pc->printf("Button 1\n\r");
}

void button2Event()
{
    pc->printf("Button 2\n\r");
}

void button3Event()
{
    pc->printf("Button 3\n\r");
}

void button4Event()
{
    pc->printf("Button 4\n\r");
}

void ir1Event()
{
    pc->printf("IR-1\n\r");
    mpu9250->vx_old = 10.5;
}

void readIMUThread()
{
    pc->printf("in IMU-Thread\n\r");
    while(1) {
        pc->printf("vx: %f\n\r", mpu9250->getVBuffer());
        wait(0.4);
    }
}



int main()
{
    pc = new Serial(USBTX, USBRX);
    pc->baud(9600);

    // Setup of IMU (Constructor calls setup-function)
    mpu9250 = new MPU9250(pc);

    imuthread.start(readIMUThread);

    // Request the shared queue
    EventQueue *queue = mbed_event_queue();
    pc->printf("Starting in context %p\r\n", Thread::gettid());


    button1.rise(queue->event(button1Event));
    button2.rise(queue->event(button2Event));
    button3.rise(queue->event(button3Event));
    button4.rise(queue->event(button4Event));
    ir1.rise(queue->event(ir1Event));
    
    // Setup complete, so we now dispatch the shared queue from main
    queue->dispatch();
}