/* Copyright (c) 2015 ARM Ltd., MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
*
*  KXTJ3 Accelerometer library
*
*  @author  Toyomasa Watarai
*  @version 1.0
*  @date    30-December-2015
*
*  Library for "KXTJ3 Accelerometer library" from Kionix a Rohm group
*    http://www.kionix.com/product/KXTJ3-1020
*
*/

#include "mbed.h"
#include "KXTJ3.h"

//KXTJ3::KXTJ3(PinName sda, PinName scl, int addr) : m_i2c(sda, scl), m_addr(addr)
//{
//    initialize();
//}

KXTJ3::KXTJ3(I2C* i2c_obj, int addr) : m_i2c(i2c_obj), m_addr(addr)
{
    initialize();
}

KXTJ3::~KXTJ3()
{
}

void KXTJ3::initialize()
{
//    unsigned char buf;
    unsigned char reg[2];
/*
    DEBUG_PRINT("KXTJ3 init started\n\r");
    readRegs(KXTJ3_WHO_AM_I, &buf, 1);
    if (buf != KXTJ3_WAI_VAL) {
        DEBUG_PRINT("KXTJ3 initialization error. (WAI %d, not %d)\n\r", buf, KXTJ3_WAI_VAL);
        DEBUG_PRINT("Trying to config anyway, in case there is some compatible sensor connected.\n\r");
    }
*/

    readRegs(KXTJ3_CNTL1, reg, 1);
    if(reg[0]!=0xC0){

        reg[0] = KXTJ3_CNTL1;
        reg[1] = 0x40;
        writeRegs(reg, 2);

        reg[0] = KXTJ3_ODCNTL;
        reg[1] = 0x01;
        writeRegs(reg, 2);

        reg[0] = KXTJ3_CNTL1;
        reg[1] = 0xC0;
        writeRegs(reg, 2);}
}
    
float KXTJ3::getAccX()
{
    return (float(getAccAxis(KXTJ3_XOUT_L))/16384);
}

float KXTJ3::getAccY()
{
    return (float(getAccAxis(KXTJ3_YOUT_L))/16384);
}

float KXTJ3::getAccZ()
{
    return (float(getAccAxis(KXTJ3_ZOUT_L))/16384);
}

void KXTJ3::getAccAllAxis(float * res)
{
    res[0] = getAccX();
    res[1] = getAccY();
    res[2] = getAccZ();
}

int16_t KXTJ3::getAccAxis(uint8_t addr)
{
    int16_t acc;
    uint8_t res[2];

    readRegs(addr, res, 2);
    acc = ((res[1] << 8) | res[0]);
    return acc;
}

void KXTJ3::readRegs(int addr, uint8_t * data, int len)
{
    int read_nok;
    char t[1] = {addr};
    
    m_i2c->write(m_addr, t, 1,true);
    read_nok = m_i2c->read(m_addr, (char *)data, len);
    if (read_nok){
        DEBUG_PRINT("Read fail\n\r");        
        }
}

void KXTJ3::writeRegs(uint8_t * data, int len)
{
    m_i2c->write(m_addr, (char *)data, len);
}
