/*
Heart Beat Monitor v1.0 w/ BlueBeat(Java-based program for mobile phones) & BlueBeat for PC
Authors: Dejan Volk & Blaz Magdic
3rd grade of Computer Science, Faculty of Electrical Engineering and Computer Science
Maribor, Slovenia

Used for sending information about heart beats per minute to the mobile phone via
Bluetooth module WT11-A-AI made by Bluegiga.

Description of pins used:

p5 - RESET switch for Polar's RMCM01 OEM module
p8 - RESET switch on WT11
p9 - TX for communicating with WT11
p10 - RX for communicating with WT11
p11 - DigitalIn for Polar's RMCM01 OEM module (pin HR)
p12 - DigitalIn for Polar's RMCM01 OEM module (pin FPLS)

Possible improvements:
- Integrating a LCD monitor that will use the serial port to display information about the current heart beat
- Implementing a more efficient algorithm to calculate the heart beat
- Better code comments (doh)

*/

#include "mbed.h"

//************global declarations*****************
Serial s_port(p9,p10);
DigitalOut led_yes(LED1); //visual indicator for sending data to WT11
DigitalOut reset(p8);  //reset trigger on WT11
DigitalOut reset_RMCM(p5);    //reset trigger on RMCM01
InterruptIn heartBeat(p12);
Timer timer;
int interval;    //interval between heartbeats
int intrHB;      //heartbeats per minute
int baud_rate = 115200;
int bits = 8;
int stop_bits = 1;
int counter_HB = 0;
int array[3];        //small array for storing heart beats
bool intrPin = false;
int previous = 11;    //variable that stores the previously calculated heartbeat
//***********end of global declarations*************

void initWT11() {       //init function for initial configuration of WT11 module
    int zero = 0;
    int high = 1;
    reset.write(zero); //Initializing WT11 for inputting commands
    wait(0.2);
    reset.write(high);
    wait(0.01);
    reset.write(zero);
    wait(2);
    //Configuration for WT11 - setting it to slave mode
    s_port.printf("SET BT PAGEMODE 3 2000 1\n");
    s_port.printf("SET BT NAME HBMWT11\n");
    s_port.printf("SET BT ROLE 0 f 7d00\n");
    s_port.printf("SET CONTROL ECHO 0\n");
    s_port.printf("SET BT AUTH * 1234\n");
    s_port.printf("SET CONTROL ESCAPE 43 00 0\n");
    s_port.printf("SET CONTROL CD 00 0\n");
    s_port.printf("SET CONTROL BAUD 115200,8n1\n");
}

void initRMCM() { //init function for initial configuration of RMCM01
    int zero = 0;
    int high = 1;
    reset_RMCM.write(high);
    wait(0.1);
    reset_RMCM.write(zero);
    wait(0.1);
    reset_RMCM.write(high);
}

void intrTrigRise() {
    led_yes=1;    //triggering the indicator led
    interval=timer.read_ms();    //reads the interval
    timer.stop();
    timer.reset();          //resets the timer
    timer.start();          //starts the timer
    intrPin = true;        //sets the interrupt to true
    heartBeat.mode(PullNone);
    wait(0.29);
    heartBeat.mode(PullUp);
}

void interpolation() {
    if (interval != 0) {  //avoiding divide-by-zero error
        array[counter_HB] = interval;
        counter_HB++;
        led_yes=0;

        if (counter_HB == 3) {     //when the array is full, start calculating the average heartbeat
            counter_HB = 0;
            int minute = 60000;
            int avrg = 0;
            int temp = 0;
            int flag = 1;
            int avg = 0;

            for (int i = 1; i <= 3 && flag; i++) {    //bubble sort in descending order
                flag = 0;

                for (int j = 0; j < 2; j++) {
                    if (array[j+1] > array[j]) {
                        temp = array[j];
                        array[j] = array[j+1];
                        array[j+1] = temp;
                        flag = 1;
                    }
                }
            }

            int sum1 = (60000/array[0]) - (60000/array[1]);        //taking the middle value and calculate the difference
            int sum2 = (60000/array[2]) - (60000/array[1]);        //between both remaining values

            if ((sum1 >= -10 || sum1 <= 10) || (sum2 >= -10 || sum2 <= 10)) {        //if all values do not deviate by +/- 10 heart beats
                for (int i = 0; i < 3; i++) {                                        //then take all 3 and calculate the average
                    avrg+=array[i];
                }
                avg = avrg/3;
            } else if ((sum1 >= -10 || sum1 <= 10) || (sum2 > 10 || sum2 < -10)) { //if 2nd sum deviates for more than +/- 10 heartbeats
                avrg = array[0] + array[1];                                        //take the elements of 1st sum
                avg = avrg/2;
            } else if ((sum1 < -10 || sum1 > 10) || (sum2 <= 10 || sum2 >= -10)) { //if 1st sum deviates for more than +/- 10 heartbeats
                avrg = array[2] + array[1];                                        //take the elements of 2nd sum
                avg = avrg/2;
            } else {
                avg = previous;        //if all 3 values deviate for more than -/+ 10 heart beats, discard all and show the previous 
            }                          //"good" heartbeat


            intrHB = minute/avg;    //interpolating the interval to 1 min
            intrPin = false;            //setting the interrupt to false
            s_port.printf("#%i*",intrHB);
            previous = avg;
        }
        intrPin = false;
    } else
        intrPin=false;
}

int main() {
    initRMCM();                            //calling init function for RMCM01
    s_port.baud(baud_rate);
    s_port.format(bits,Serial::None,stop_bits);
    initWT11();                         //calling the init function for setting WT11
    s_port.printf("SELECT 0\n");        //switching from COMMAND mode to DATA mode

    while (1) {
        heartBeat.rise(&intrTrigRise);    //trigger for interrupt
        if (intrPin == true && interval != 0) {  //if interrupt is true and interval is not 0, send data
            interpolation();
        }
    }
}
