#include "victimBreath.h"
#include "mbed.h"

AnalogIn windSensor(p17);
DigitalOut myLED(LED1);
Ticker breathReader;

volatile float thresh = windSensor*1.4;
//volatile bool Breath = false;     // set on each visit to interrupt routine
volatile bool isBreathing = false;
volatile int breathCount = 0; //increment if breath is above thresh on each visit to interrupt routine

victimBreath :: victimBreath(){
    }
    
void victimBreath :: startReading(){
    breathReader.attach(this, &victimBreath::sample, .002f);
    //volatile float a = windSensor;
    //printf("\nwindsensor reads: %f", a);
    //printf("\nthresh is: %f", thresh);
}

void victimBreath :: stopReading(){
    breathReader.detach();
    __enable_irq();
}

void victimBreath :: reset() {        
    //thresh = windSensor*1.2; //set thresh to an appropraite percent above the baseline reading
    //Breath = false;     // true victims breath crosses thresh
    isBreathing = false; //true if we get 3 'Breaths' in the calling programs time window-->means victim is breathing
    breathCount = 0;       
}

//call this member function to see if victim is breathing
bool victimBreath :: breathDetected() {
    return isBreathing; //only return positive if we get the critical number of Breaths in the given time window
}


// THIS IS THE TIMER 2 INTERRUPT SERVICE ROUTINE. 
// Timer 2 makes sure that we take a reading every 2 miliseconds
void victimBreath :: sample() {                         // triggered when Timer2 counts to 124
  __disable_irq();            
  float readVal = windSensor;                          // sample
  

    //check to see if victim is breathing at all above natural variation in sensor noise
  if(readVal >= thresh){       
      breathCount++;                         //increment global counter
    }
  if(breathCount >= 3){ //should set this higher if want more certainty in victim breathing
      isBreathing = true;
  }
  __enable_irq();                               // enable interrupts again
        //return; 
}

  