#include "sealDetect.h"

sealDetect::sealDetect(PinName p1, PinName p2, PinName p3)
    :seal_detect(p1, p2), strip(p3, 4){
    sealed = false;
    thresh = 4000.0;
    }
    
void sealDetect :: startReading(){
    sealReader.attach(this, &sealDetect::checkSeal, .002f);
}

void sealDetect :: stopReading(){
    sealReader.detach();
    __enable_irq();
}

void sealDetect :: reset() {        
    sealed = false;       
}

//call this member function to see if victim is breathing
bool sealDetect :: sealDetected() {
    return sealed; //only return positive if all chann floats fall below thresh
}


// THIS IS THE TIMER 2 INTERRUPT SERVICE ROUTINE. 
// Timer 2 makes sure that we take a reading every 2 miliseconds
void sealDetect :: checkSeal() { 
  __disable_irq();            

  char    read_bytes[2]; //byte vector returns 2 bytes of data form adc
  char cmd = 0x2;

  
  //read point at bridge of nose
  seal_detect.write( 0x90, &cmd, 1 );
  seal_detect.read( 0x91, read_bytes, 2 );
  chan0 = ((read_bytes[0] << 8) + read_bytes[1]);
  
  //read point at right cheek
  cmd = 0x2;
  seal_detect.write( 0x90, &cmd, 1 );
  seal_detect.read( 0x91, read_bytes, 2 );
  chan2 = ((read_bytes[0] << 8) + read_bytes[1]);
  
  //read point right above chin
  cmd = 0x4;
  seal_detect.write( 0x90, &cmd, 1 );
  seal_detect.read( 0x91, read_bytes, 2 );
  chan4 = ((read_bytes[0] << 8) + read_bytes[1]); 
  
  //read point at left cheek
  cmd = 0x6;
  seal_detect.write( 0x90, &cmd, 1 );
  seal_detect.read( 0x91, read_bytes, 2 );
  chan6 = ((read_bytes[0] << 8) + read_bytes[1]); 
  
  printf("\n\nchan0 = %f", chan0);
  printf("\nchan2 = %f", chan2);
  printf("\nchan4 = %f", chan4);
  printf("\nchan6 = %f", chan6);
  //wait(0.5);

    //check each seal point
  if(chan0<=thresh){       
      //send command to first neopixel to be green;  
      strip.setPixel(0,0xFF,0,0); //green                      
    }
  else{
      //send command to first neopixel to be red;
      strip.setPixel(0,0,0xFF,0); //red
  }
  strip.write();
  if(chan2<=thresh){       
      //send command to second neopixel to be green;  
      strip.setPixel(1,0xFF,0,0); //green                       
    }
  else{
      //send command to second neopixel to be red;
      strip.setPixel(1,0,0xFF,0); //red
  }
  strip.write();
  if(chan4<=thresh){       
      //send command to third neopixel to be green;   
       strip.setPixel(2,0xFF,0,0); //green                      
    }
  else{
      //send command to third neopixel to be red;
       strip.setPixel(2,0,0xFF,0); //red
  }
  strip.write();
  if(chan6<=thresh){       
      //send command to fourth neopixel to be green;
      strip.setPixel(3,0xFF,0,0); //green                         
    }
  else{
      //send command to fourth neopixel to be red;
      strip.setPixel(3,0,0xFF,0); //red
  }
  strip.write();
  
  if(chan0 <= 1000.0 && chan2 <=1000.0 && chan4 <=1000.0 && chan6 <=1000.0){ //check for full seal
      sealed = true;
  }
  else{
      sealed = false;
  }
  __enable_irq();                               // enable interrupts again
        //return; 
}

  