/**
 *@section DESCRIPTION
 * mbed SolarNanogrid  Library
 * Utility extends SolarNanoGrid.
 * Utility Manages the agri-equipment and the GPRS .
 * The ID must be  FE 00.
 *@section LICENSE
 * Copyright (c) 2016, Malcolm McCulloch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * @file "Utility.h"
 */

#ifndef UTILITY_H
#define UTILITY_H
#include <mbed.h>
#include "NRF2401P.h"
#include "nRF24l01.h"
#include "SDFileSystem.h"
#include "SolarNanoGrid.h"



/** \brief Utility manages the human interface and talks to the lockers.
 *
 *  The config.ini must start with H, The ID must be  FE 00.
 *
 */
class Utility : public SolarNanoGrid
{
public:

    // *********************
    // * Public variables: *
    // *********************
    // *********************
    // * Public functions: *
    // *********************

    /**
     * Constructor:
     */
    Utility(FILE* fp, Serial *pc);

    // Main loop function:
    virtual void loop(void);

protected:
    // *********************
    // * Protected hardware: *
    // *********************
    DigitalOut *husker;         /**<  DigitalOut(PTD1,0);*/
    DigitalOut *incubator;      /**<  DigitalOut(PTD3,0);*/
    DigitalOut *posho;          /**<  DigitalOut(PTD2,0); */
    InterruptIn* button;
    Ticker* rxWatch;
    Ticker* oneSecond;

    // *********************
    // * Protected flags: *
    // *********************

    volatile bool flagRotate;
    volatile char flagNrf;
    volatile char flagOneSecond;

    // *********************
    // * Protected variables: *
    // *********************

    int pipe;                       /**<  The pipe on which the data was received      */
    int width;                      /**<  The number of bytes of received data      */

    char * sdBuffer;
    long long baseAddr;
    long long utilityAddr;
    char *timeValue;                /**<  String of time, see intOneSecond()     */
    volatile time_t now, lastRxTme;

    // *********************
    // * Protected functions: *
    // *********************
    /**
     * When the button is pressed print status
     */
    void intButton() ;
    /**
     * set flag for 1 second interrupts
     */
    void intOneSecond();
    /**
     * Updates time string
     */
    void doOneSecond();
    /**
     * Responds to the received signals from HMI
     */
    void doNrf();
    /**
     * called when the nrf creates an interrupt.
     *
     */
    void intNrf();

    /**
     * Cleans the receiver
     */
    void intRxClean();

    /**
     * Turns the Husker on
     */
    void turnHuskerOn(int on);


    /**
     * Turns the Incubator on
     */
    void turnIncubatorOn(int on);
    /**
     * Turns the posho on
     */
    void turnPoshoOn(int on);

};


#endif
