/**
 *@section DESCRIPTION
 * mbed SolarNanogrid  Library
 * Utility extends SolarNanoGrid.
 * Utility Manages the agri-equipment and the GPRS .
 * The ID must be  FE 00.
 *@section LICENSE
 * Copyright (c) 2016, Malcolm McCulloch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * @file "Utility.cpp"
 */
#include "Utility.h"
#define FUNCNAME "UTILITY"
#include "defs.h"
Utility::Utility(FILE* fp,Serial *pc) :
SolarNanoGrid(fp,pc) {
    DBG("Initialize class Utility");
    //
    // Flags
    //
    flagNrf=0;
    flagOneSecond=0;

    //
    // Variables
    //


    sdBuffer = (char *) calloc(SDBUFFERSIZE,1);
    timeValue = (char *) calloc(32, 1);
    doOneSecond();
    //
    // Setup relays
    //
    husker = new DigitalOut(PTD1,0);
    incubator = new DigitalOut(PTD3,0);
    posho = new DigitalOut(PTD2,0);

    //
    // Setup NRF
    //
    baseAddr = ((long long) communityID << 16) + (id & 0XFFFF);
    utilityAddr = baseAddr & 0XFFFFFF0000 | 0xFE00;
    DBG("  Channel:%x, Address %llx Util Address %llx", chan, baseAddr, utilityAddr);
    setAsRX(utilityAddr);

    //
    // Interrupts
    //

    nrfInt = new InterruptIn(PTC18);
    nrfInt->fall(this, &Utility::intNrf); // attach nrf interrupt.

    button = new InterruptIn(SW2);
    button->fall(this, &Utility::intButton);


    rxWatch = new Ticker();
    rxWatch->attach(this, &Utility::intRxClean, 30.14151);

    oneSecond = new Ticker();
    oneSecond->attach(this, &Utility::intOneSecond, 1.0);

}

// ------------------------------------------------------------------------
// Interrupt routines
// ------------------------------------------------------------------------
/**
 * When the button is pressed print status
 */
void Utility::intButton() {
    DBG("int Button");
    intRxClean();
}

void Utility::intOneSecond() {
    flagOneSecond = 1;
}

void Utility::doOneSecond() {
    now = time(NULL);
    sprintf(timeValue, "T %x", now);
    *ledGreen = !*ledGreen;
    //  DBG("One second: %s", timeValue);
}

/**
 * Responds to the received signals from HMI
 */
void Utility::doNrf()
{

    //DBG("doNrf>>");
    // Now check which pipe
    if (pipe>1) { //A battery
        switch (dataRx[0]) {
        case ('D'): { // Directory name.
            *ce = 0;
            //sscanf (&dataRx[2],"%s",&(dirNames[p][0]));
            break;
        }

        }

    }
}

void Utility::loop(){
    return;
}


/**
 * called when the nrf creates an interrupt.
 *
 */
void Utility::intNrf() {

    int bID = 0;
    int status = 0;
    //
    //Get status and pipe
    //
    spiNRF();
    status = nrf->checkStatus();
    pipe = (status >> 1);
    pipe = (pipe & 0x0007);

    //
    // Check if data received
    //
    if (((status >> RX_DR) & 01) == 1) { // Received a packet
        // Get the data
        width = nrf->getRxData(dataRx);
        dataRx[width] = '\0';
        //Process the acknowledge
        //      if ((pipe>=2)&&(battIn[battPipes[pipe - 2]] == SENDING)) { // A file is being transferred.
        //          nrf->acknowledgeData("S ", 2, pipe);
        //          flagNrf = 1;
        //      } else
        if (dataRx[0] == 'T') {
            // Sends the time - this is updated in doOneSecond()
            nrf->acknowledgeData(timeValue, strlen(timeValue), pipe);
        } else  {
            nrf->acknowledgeData(dataRx, 2, pipe);
            DBG("intNrf>%s %x",dataRx,bID);
        }
        // Process data
        if (pipe == 0) { // Utility channel
            switch(dataRx[0]){
            case 'h':{
                if (dataRx[1] == 's'){
                    turnHuskerOn(1);
                    *ledBlue=0;
                }else if (dataRx[1] == 'x'){
                    turnHuskerOn(0);
                    *ledBlue=1;
                }
                break;
            }
            case 'i':{
                if (dataRx[1] == 's'){
                    turnIncubatorOn(1);
                    *ledBlue=0;
                }else if (dataRx[1] == 'x'){
                    turnIncubatorOn(0);
                    *ledBlue=1;
                }
                break;
            }
            case 'p':{
                if (dataRx[1] == 's'){
                    turnPoshoOn(1);
                    *ledBlue=0;
                }else if (dataRx[1] == 'x'){
                    turnPoshoOn(0);
                    *ledBlue=1;
                }
                break;
            }
            }

        }else if (pipe>1) {
            flagNrf = 1;
        }

        lastRxTme = now;

    }

    DBG("intNRF> int rx");
    nrf->clearStatus();
    *ledBlue = !*ledBlue;

}

/**
 * Cleans the receiver
 */
void Utility::intRxClean() {
    if (now - lastRxTme>60){
        nrfFlush();
        wait(0.01);
        nrfFlush();
        DBG("intRxClean < status=%x", nrf->checkStatus());
    }
}
/**
 * Turns the Husker on
 */
void Utility::turnHuskerOn(int on){
    DBG("Turn husker %d",on);
    *husker=on;
}
/**
 * Turns the Incubator on
 */
void Utility::turnIncubatorOn(int on){
    DBG("Turn incubator %d",on);
    *incubator = on;
}

/**
 * Turns the Posho on
 */
void Utility::turnPoshoOn(int on){
    DBG("Turn posho %d",on);
    *posho = on;
}
