/**
 *@section DESCRIPTION
 * mbed SolarNanogrid  Library
 *@section LICENSE
 * Copyright (c) 2016, Malcolm McCulloch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * @file "SolarNanoGrid.h"
 */

#ifndef SOLARNANOGRID_H
#define SOLARNANOGRID_H
#include <mbed.h>
#include <pinmap.h>
#include <RawSerial.h>
#include "NRF2401P.h"
#include "SDFileSystem.h"







/** \brief A library for the base of the solar nano grid controllers.
 *
 *   This library contains the code to drive batteries, hub etc.
 */
class SolarNanoGrid {
public:
    // *********************
    // * Public variables: *
    // *********************
    int sdVersion;
    unsigned int id;
    unsigned int communityID;
    int chan;
    char dataRx[33];
    char dataTx[33];
    Serial *pc;

    DigitalOut *ledRed, *ledGreen, *ledBlue;

    // *********************
    // * Public functions: *
    // *********************

    // Constructor:

    /**
     * Reads in config.ini and sets up the CommunityId, UserId, and the channel.
     */

    SolarNanoGrid(FILE* fp, Serial *pc);
    /**
     * Asks the user for the time and sets the real time clock
     */
    void userSetRTCpc();

    // Main loop function:
    virtual void loop(void) = 0;

    

protected:
    // *********************
    // * Protected interrupts: *
    // *********************
    InterruptIn* nrfInt;

    // **********************
    // * Protected variables: *
    // **********************
    DigitalOut* ce;
    FILE* _fp;
    NRF2401P* nrf;


    // *********************
    // * Protected functions: *
    // *********************
    /**
     * Flushes the rx and tx buffers and resets the status.
     */
    void nrfFlush();

    /**
     * Set NRF as RX and flush
     */
    void setAsRX(long long addr);

    /**
     * Sets NRF as TX and flushes the NRF
     */
    void  setAsTX(long long addr);

private:
    // **********************
    // * Private variables: *
    // **********************

};

// Other functions:

// spi pin assignments:
/**
 * Turns SPI on for SD card
 */
void spiSD(void);

/**
 * Turns SPI on for nrf
 */
void spiNRF(void);


/**
 * Class to hold of the Song Settings
 */

class SongSettings{
    public:
        // Constructor:
        SongSettings();
        
        // Variables:
        char role;
        int sdVersion;
        unsigned int communityID;
        unsigned int id;
        int chan;
        char LogDir[128];
        bool LoadSongSettings(void);
        
};

// Creates a new config file, BLOCKING function:
void doNewConfig(Serial *pc);

#endif  /* SOLARNANOGRID_H */
