/**
 *@section DESCRIPTION
 * mbed SolarNanogrid  Library - definitions for messages
 *@section LICENSE
 * Copyright (c) 2016, Malcolm McCulloch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * @file "defs.h"
 */
#define SDBUFFERSIZE 65536
//
// Defines which messages to print
//
#define DEBUG
#define INFOMESSAGES
#define WARNMESSAGES
#define ERRMESSAGES

#ifdef DEBUG
#define DBG(x, ...) printf("["FUNCNAME" : DBG] "x" <line %d>\r\n", ##__VA_ARGS__,__LINE__);
#else
#define DBG(x, ...)
#endif

#ifdef ERRMESSAGES
#define ERR(x, ...) printf("["FUNCNAME" : ERR] "x"\r\n", ##__VA_ARGS__);
#else
#define ERR(x, ...)
#endif

#ifdef WARNMESSAGES
#define WARN(x, ...) printf("["FUNCNAME" : WARN] "x"\r\n", ##__VA_ARGS__);
#else
#define WARN(x, ...)
#endif

#ifdef INFOMESSAGES
#define INFO(x, ...) printf("["FUNCNAME" : INFO] "x"\r\n", ##__VA_ARGS__);
#else
#define INFO(x, ...)
#endif
