/**
 *@section DESCRIPTION
 * mbed SolarNanogrid  Library
 * Locker extends SolarNanoGrid.
 * Locker interacts with the batteries.
 * The ID must end in 00.
 *@section LICENSE
 * Copyright (c) 2016, Malcolm McCulloch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * @file "Locker.h"
 */

#ifndef LOCKER_H
#define LOCKER_H
#include <mbed.h>
#include "NRF2401P.h"
#include "nRF24l01.h"
#include "SDFileSystem.h"
#include "SolarNanoGrid.h"


// Battery states
#define CHECKED_OUT 0
#define CHECKED_IN 1
#define ON_AIR 2
#define SENDING 3


/** \brief Locker interacts with the batteries.
 *
 *  The config.ini must start with L
 *   This library contains the code to drive batteries, hub etc.
 */
class Locker : public SolarNanoGrid
{
public:

    // *********************
    // * Public variables: *
    // *********************


    // *********************
    // * Public functions: *
    // *********************

    // Constructor:
    Locker(FILE* fp, Serial *pc);

    // Main loop function:
    virtual void loop(void);



protected:
    // *********************
    // * Protected hardware: *
    // *********************


    // *********************
    // * Protected interrupts: *
    // *********************

    InterruptIn* button;
    Ticker* rxWatch;
    Ticker* oneSecond;
    // **********************
    // * Protected variables: *
    // **********************

    /**
     * Open channel address of the locker
     */
    long long openAddr;

    /**
     * Channel address for Utility
     */
    long long addrUtil;
    /**
     * Array of battery states
     */
    char* battIn;                   /**< array of all battery states    */
    char* battPipes;                /**<  array of RX pipes             */
    char* dirNames[4];              /**<  The directory for each pipe   */
    char* fileNames[4];             /**<  The filename of each pipe     */
    unsigned int lengthFile[4];     /**<  The file length of each pipe  */
    char* temp;
    char* sdBuffer;                 /**<  The ram buffer for the SD card- large!    */
    unsigned int sdBuffPnt;         /**<  SD buffer pointer             */
    int battQP;                     /**<  Battery queue pointer         */
    int pipeQP;                     /**<  pipe queue pointer; add 2 to get pipe     */
    int pipe;                       /**<  The pipe that has last received data      */
    int width;                      /**<  The number of bytes of received data      */
    int userIDDrop;                 /**< User ID of drop off from HMI*/
    int numBatDrop;                     /**< Num bat dropped off*/

    char *maxChargeValue;
    char *timeValue;
    
    DigitalOut *pods[16];           /**< Array of gpio to control the pod relays */

    volatile time_t now;
    volatile time_t lastRxTme;
    
    volatile float maxCharge;

    // *********************
    // * Protected flags: *
    // *********************
    volatile bool flagRotate;
    volatile char flagNrf;
    volatile char flagOneSecond;

    // **********************
    // * Protected functions: *
    // **********************
    /**
     * set flag for 1 second interrupts
     */
    void intOneSecond();
    /**
     * Updates time string
     */
    void doOneSecond();
    /**
     * Called when the nrf creates an interrupt.
     */
    void intNrf();
    /**
    * Responds to the received signals from Master and Batteries
    */
    void doNrf();

    /**
     * When the button is pressed print status
     */
    void intButton();
    /**
     * Cleans the receiver
     */
    void intRxClean();
    /**
     * Rotates one battery the ON_AIR batteries.
     */
    void doRotate();

    /**
     * Take the info and saves to a file via a buffer.
     **/
    void saveFile (int p,char *data, int width);
    /**
    * writes the sdbuffer to file
    */
    void flushSDBuffer(int p);

//    /**
//     * Set NRF as RX
//     */
//    void setAsRX();
//
//    /**
//     * Set NRF as TX
//     */
//    void setAsTX();

    /**
     * Turns a pod power on
     */
    void turnPodOn(int pod, int on);

private:
    // **********************
    // * Private variables: *
    // **********************



};
#endif
