/**
 * HubUser.cpp
 *
 * HubUser class. A HubUser is an object containing a uid number, an rfid 
 * number, a max number of batteries that can be checked out, a locker
 * number, and a pod within a locker.
 * 
 * Author: Daniel Yang
 */

#include "HubUser.h"

HubUser::HubUser()
: uid(0), rfid(0), accountCredit(0), locker(0),
  pod(0), batteriesOut(0),
  batterySubscription(0), name(NULL) { }

HubUser::HubUser(uint32_t uid, uint32_t rfid, int32_t accountCredit, 
        int32_t locker, int32_t pod, int32_t batteriesOut,
        int32_t batterySubscription, char* name)
: uid(uid), rfid(rfid), accountCredit(accountCredit), locker(locker), 
  pod(pod), batteriesOut(batteriesOut), 
  batterySubscription(batterySubscription), name(name) { }

uint32_t HubUser::getUid() {
    return uid;
}

uint32_t HubUser::getRfid() {
    return rfid;
}

int32_t HubUser::getCredit() {
    return accountCredit;
}

int32_t HubUser::getLocker() {
    return locker;
}

int32_t HubUser::getPod() {
    return pod;
}

int32_t HubUser::getBatteriesOut() {
    return batteriesOut;
}

int32_t HubUser::getBatteriesMax() {
    return batterySubscription;
}

char * HubUser::getName(){
    return name;
}
void HubUser::setUid(uint32_t uid) {
    this->uid = uid;
}

void HubUser::setRfid(uint32_t rfid) {
    this->rfid = rfid;
}

void HubUser::setCredit(int32_t credit) {
    this->accountCredit = credit;
}

void HubUser::setLocker(int32_t locker) {
    this->locker = locker;
}

void HubUser::setPod(int32_t pod) {
    this->pod = pod;
}

void HubUser::setBatteriesOut(int32_t batteries) {
    this->batteriesOut = batteries;
}

void HubUser::setBatteriesMax(int32_t batteries) {
    this->batterySubscription = batteries;
}

void HubUser::dropOffBattery(int32_t batteries) {
    this->batteriesOut -= batteries;
}

void HubUser::pickUpBattery(int32_t batteries) {
    this->batteriesOut += batteries;
}

void HubUser::decreaseCredit(int32_t credit) {
    this->accountCredit -= credit;
}
