 /**
 * HubLogging.h
 *
 * Logging utility functions for the main control hub mbed.
 * 
 * Author: Daniel Yang
 */

#ifndef HUBLOGGING_H
#define HUBLOGGING_H

#include "mbed.h"
#include "HubUser.h"

/*
 * these actions depend on a known user using the system
 */
enum HubActionForLogging {
    hubAction_BatteryRfidScanned,       /**< Battery Rfid was scanned */
    hubAction_PoshoRfidScanned,         /**< Posho Rfid was scanned */
    hubAction_IncubatorRfidScanned,     /**< Incubator Rfid was scanned */
    hubAction_Exit,                     /**< User hits exit */
    hubAction_OneBatteryDropped,        /**< One battery dropped off */
    hubAction_TwoBatteryDropped,        /**< Two batteries dropped off */
    hubAction_ThreeBatteryDropped,      /**< Three batteries dropped off */
    hubAction_OneBatteryPicked,         /**< One battery picked off */
    hubAction_TwoBatteryPicked,         /**< Two batteries picked off */
    hubAction_ThreeBatteryPicked,       /**< Three batteries picked off */
    hubAction_OneKiloPosho,             /**< One kilo of posho usage */
    hubAction_TwoKiloPosho,             /**< Two kilos of posho usage */
    hubAction_ThreeKiloPosho            /**< Three kilos of posho usage */
};

/*
 * any rfid can log errors regarding an unknown tag being read
 */
enum HubLoggingRfidSource {
    source_battery,                     /**< From battery rfid */
    source_posho,                       /**< From posho rfid */
    source_incubator                    /**< From incubator rfid */
};

/**
 * Log an action from a selection of predefined actions done by the current user
 * Actions used with this method should require a known user to be using system
 * @param action - enumerated HubActionForLogging that selects from predefined actions
 * @param userIndex - int corresponding to the index of the user in the user table
 */
void logActionWithUserInfo(enum HubActionForLogging action, HubUser *user);

/**
 * Log an error - RFID not associated with a known user is scanned
 * @param unknownRfid - uint32 for the unique ID of the unknown rfid tag
 */
void logErrorUnknownRfidScanned(uint32_t unknownRfid, enum HubLoggingRfidSource source);

#endif