/**
* @author Damien Frost
*
* @section LICENSE
*
*   Copyright (c) 2016 Damien Frost
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy
*   of this software and associated documentation files (the "Software"), to deal
*   in the Software without restriction, including without limitation the rights
*   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*   copies of the Software, and to permit persons to whom the Software is
*   furnished to do so, subject to the following conditions:
*
*   The above copyright notice and this permission notice shall be included in
*   all copies or substantial portions of the Software.
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*   THE SOFTWARE.
*
* @file "ADC.h"
*
* @section DESCRIPTION
*   Configuration of the ADC for the IoT example.
*
*/

#ifndef IQ_ADC_H
#define IQ_ADC_H

// Properties of the internal temperature sensor:
#define IT_VMIN         1.7f
#define IT_VMAX         3.3f
#define IT_AVG_SLOPE    0.0025f
#define IT_V25          0.76f

#define ADC_MAX     4095.0f

#define STARTADCCONVERSION              ADC1->CR2 |= ADC_CR2_SWSTART   // This command starts the ADC Conversion.
#define ADCCONVERSIONCOMPLETE           ((ADC1->SR & ADC_SR_EOC) > 0)  // This command returns true when the ADC conversion is complete.

void ConfigureADC(void);


#endif  /* IQ_ADC_H */