/**
* @author Damien Frost
*
* @section LICENSE
*
*   Copyright (c) 2016 Damien Frost
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy
*   of this software and associated documentation files (the "Software"), to deal
*   in the Software without restriction, including without limitation the rights
*   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*   copies of the Software, and to permit persons to whom the Software is
*   furnished to do so, subject to the following conditions:
*
*   The above copyright notice and this permission notice shall be included in
*   all copies or substantial portions of the Software.
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*   THE SOFTWARE.
*
* @file "ADC.cpp"
*
* @section DESCRIPTION
*   Configuration of the ADC for the IoT example.
*
*/

#include "ADC.h"
#include "globals.h"
#include "mbed.h"


//#define DEBUG
#define INFOMESSAGES
#define WARNMESSAGES
#define ERRMESSAGES
#define FUNCNAME "ADC"
#include "messages.h"


void ConfigureADC(void){
    
    unsigned int value;
    
    // ensure power is turned on
    // Grabbed from lines 54-57 of analogin_api.c
    // This turns on the clock to Ports A, B, and C
    RCC->AHB1ENR |= RCC_AHB1ENR_GPIOAEN | RCC_AHB1ENR_GPIOBEN | RCC_AHB1ENR_GPIOCEN;
    // This turns on the clock to the ADC:
    RCC->APB2ENR |= RCC_APB2ENR_ADC1EN;
    
    
    // Turn on the ADC:
    value = ADC_CR2_ADON;
    ADC1->CR2 = value;
    wait_us(100);
    
    // Set the EOC flag at the end of every regular conversion:
    ADC1->CR2 |= ADC_CR2_EOCS;
    
    // Turn on the internal temperature sensor:
    ADC->CCR |= ADC_CCR_TSVREFE;
    
    // Set the first (and only channel) to convert to CH16, the internal temperature sensor:
    ADC1->SQR3 |= ADC_SQR3_SQ1_4;
    
    // Set the sample numbers (making this bigger samples more slowly):
    ADC1->SMPR2 = ADC_SMPR1_SMP16_1 | ADC_SMPR1_SMP16_2; // Set for 144 ADC clock cycles
    
    
    INFO("ADC configuration complete!");
    DBG("ADC Registers:");
    DBG("The SR Register reads: %d", ADC1->SR);
    DBG("The CR1 Register reads: %d", ADC1->CR1);
    DBG("The CR2 Register reads: %d", ADC1->CR2);
    DBG("The JSQR Register reads: %d", ADC1->JSQR);
    
    return;
}