/**
* @author Damien Frost
*
* @section LICENSE
*
*   Copyright (c) 2016 Damien Frost
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy
*   of this software and associated documentation files (the "Software"), to deal
*   in the Software without restriction, including without limitation the rights
*   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*   copies of the Software, and to permit persons to whom the Software is
*   furnished to do so, subject to the following conditions:
*
*   The above copyright notice and this permission notice shall be included in
*   all copies or substantial portions of the Software.
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*   THE SOFTWARE.
*
* @file "StatusRep.cpp"
*
* @section DESCRIPTION
*   StatusReg implementation. A register to hold bit-wise status flags.
*
*/


#include "StatusReg.h"

StatusReg::StatusReg()
{
    _reg = 0;
    return;
}

// Set a flag:
void StatusReg::SetFlag(unsigned int flag){
    _reg |= flag;
    return;
}

// Clear a flag:
void StatusReg::ClearFlag(unsigned int flag){
    _reg &= (~flag);
    return;
}

// Check for flag
bool StatusReg::CheckFlag(unsigned int flag){
    if((_reg & flag) > 0){
        return true;
    }else{
        return false;
    }
}

// Check for no flags
bool StatusReg::AllClear(void){
    if(_reg == 0){
        return true;
    }else{
        return false;
    }
}

unsigned int StatusReg::GetReg(void){
    return _reg;
}
