/**
* @author Damien Frost
*
* @section LICENSE
*
*   Copyright (c) 2016 Damien Frost
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy
*   of this software and associated documentation files (the "Software"), to deal
*   in the Software without restriction, including without limitation the rights
*   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*   copies of the Software, and to permit persons to whom the Software is
*   furnished to do so, subject to the following conditions:
*
*   The above copyright notice and this permission notice shall be included in
*   all copies or substantial portions of the Software.
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*   THE SOFTWARE.
*
* @file "globals.h"
*
* @section DESCRIPTION
*   Global definitions for the Internet of Things example.
*
*/

#ifndef IQ_GLOBALS_H
#define IQ_GLOBALS_H

#include "mbed.h"
#include "WiflyInterface.h"
#include "Commands.h"
#include "Websocket.h"


// Wifi Interface defines:
#define TCP_SERVER_PORT 4445
#define WIFIBAUDRATE    115200
#define WIFINETWORK     2
#define CHARMSGBUFF     1024
#define TIMEOUTRECEIVEATTEMPTS  5
#define WS_PORT     4444
#define SERVER_IP "192.168.1.99"

// Pin assignments
#define VOLTAGE_SENSOR_PIN  PA_0
#define CURRENT_SENSOR_PIN  PA_1

// Hardware:
extern Serial          pc;
extern InterruptIn     UIBut1;
extern Timer           DisplayTimer;
extern DigitalOut      Led;

// Variables:
extern int ReconnectAttempts;
extern int SendCounter;
extern int IoT_ID;
extern float TempSensor;
extern float VoltageMeasurement;
extern float CurrentMeasurement;
extern float PwmPeriod_us;
extern float Duty_us;
extern char* wifissid;
extern char* wifipassword;
extern DigitalOut      db;
extern AnalogIn        VoltageSensor;
extern AnalogIn        CurrentSensor;

// Communication:
extern WiflyInterface eth;
extern Websocket ws;

// Functions:
void SensorToPu(float gain, float offset, int sensor, float* result);
void InitializeStruct(struct tf_history_t* toClear);
void SetupVar(void);
void SetButtonEvent(void);
void rt_OneStep(void);
void DisplayInputs(float CPS);
void SetSCKDCParams(bool enable, float gain);
int SetupNetwork(int Tries);
bool ConnectToServer(int Tries);
void SendNetworkData(void);
void ReceiveNetworkData(unsigned int * wifi_cmd, float * value);
void ModifyVariable(unsigned int wifi_var, float wifi_data);


#endif  /* IQ_GLOBALS_H */

