/**
* @author Damien Frost
*
* @section LICENSE
*
*   Copyright (c) 2016 Damien Frost
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy
*   of this software and associated documentation files (the "Software"), to deal
*   in the Software without restriction, including without limitation the rights
*   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*   copies of the Software, and to permit persons to whom the Software is
*   furnished to do so, subject to the following conditions:
*
*   The above copyright notice and this permission notice shall be included in
*   all copies or substantial portions of the Software.
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*   THE SOFTWARE.
*
* @file "StatusRep.h"
*
* @section DESCRIPTION
*   StatusReg implementation. A register to hold bit-wise status flags.
*
*/
 
#ifndef STATUSREG_H_
#define STATUSREG_H_

#include "StatusReg.h"

 /**
 * Interface using Wifly to connect to an IP-based network
 */
class StatusReg{
public:
    // Constructor
    StatusReg(void);
    
    // Set a flag:
    void SetFlag(unsigned int flag);
    
    // Clear a flag:
    void ClearFlag(unsigned int flag);
    
    // Check for flag
    bool CheckFlag(unsigned int flag);
    
    // Check for no flags
    bool AllClear(void);
    
    // Get Register
    unsigned int GetReg(void);
    
private:
    unsigned int _reg;
};


#endif /* STATUSREG_H_ */