#include "stm32f103c8t6.h"
#include "mbed.h"
#include "DS1820.h"

#define DATA_PIN        PA_8
 
int main() {
    DS1820 probe(DATA_PIN);
    
    while(1) {
        printf("Initiating temperature conversion\r\n");
        probe.convertTemperature(true, DS1820::this_device);         //Start temperature conversion, wait until ready
        double temperature = probe.temperature();
        int temp_integer = temperature;
        int temp_milli = (temperature - temp_integer) * 1000;
        printf("It is %d.%03dC\r\n", temp_integer, temp_milli);
        wait(1000);
    }
}
