//include the libary's

#include "mbed.h"
#include "coap.h"
#include "rgb.h"
#include "LM75B.h"

//initialise serial en the temperature sensor
Serial pc(USBTX, USBRX);
LM75B sensor(p28,p27);
//make a object from the class RGB
RGB* rgb;

//the methode to send the value of the temp sensor
//this methode is called by a get methode
void get_temp(Request* req, Response* res)
{
    if(req->hasContent()) {
           
    }
    char array[10];
    sprintf(array, "%f", (float) sensor);
    string n;
    n=sprintf (array, "%f", n);
    res -> setContent(array, 9);
    res -> setCode(CONTENT);   
}

//this methode receive the value of the LED 
//
void post_led(Request* req, Response* res)
{
    if(req->hasContent()) {
        //receive the coap data
        char* test = req->getContent();
        
        pc.printf(test);
        uint32_t hex = strtol(req->getContent(), NULL, 16);
        rgb->setColor(hex);
        res->setCode(CHANGED);
    }
    
    
}

int main()
{
    Server server;
    server.add("/led", &get_temp, GET);
    server.add("/led", &post_led, POST);
    
    rgb = new RGB(p23, p24, p25);
    rgb->setColor(0,0,255);
    pc.printf("lol\r\n");
    while(true)
    {
        server.waitForRequest();
        pc.printf("Device detected!\n");
 
    
 
    } 
        
    
}