#include "rgb.h"

RGB::RGB(PinName r_pin, PinName g_pin, PinName b_pin){
    this->r_out=new PwmOut(r_pin);
    this->g_out=new PwmOut(g_pin);
    this->b_out=new PwmOut(b_pin);
    setColor(0,0,0);
    }

void RGB::setColor(int red, int green, int blue){
    r_out->write(1.0-toFloat(red));
    g_out->write(1.0-toFloat(green));
    b_out->write(1.0-toFloat(blue));
    }

void RGB::setColor(int color){
    Color kleur=Color(color);
    r_out->write(1.0-toFloat(kleur.getRed()));
    g_out->write(1.0-toFloat(kleur.getGreen()));
    b_out->write(1.0-toFloat(kleur.getBlue()));
    }

void RGB::setColor(Color color){
    r_out->write(toFloat(color.getRed()));
    g_out->write(toFloat(color.getGreen()));
    b_out->write(toFloat(color.getBlue()));
    }
    

float RGB::toFloat (int floater){
    return (float) ((floater)/255.0f);
    }