#include "color.h"

Color::Color(int red, int green, int blue) {
 this->red=red;
 this->green=green;
 this->blue=blue;
}

Color::Color(int color) {
 this->red= (color <<16) & 0x0000FF;
 this->green= (color << 8) &0x0000FF;
 this->blue= (color << 8) & 0x0000FF;   
}

Color::Color(float red, float green, float blue) {
   this->red= floatToColorValue(red);
   this->green= floatToColorValue(green);
   this->blue= floatToColorValue(blue);
}

int Color::floatToColorValue(float value) {
    return (int) (value*255);    
}

int Color::getRed(void) {
 return red;   
}

int Color::getGreen(void) {
 return green;   
}

int Color::getBlue(void) {
 return blue;   
}

int Color::getHex(void) {
 return (red<<16)+(green<<8)+(blue<<0);  
}