/**
*Dit is de klasse color

*/

#include "color.h"

Color::Color(int red, int green, int blue){
    this->red=red;
    this->green=green;
    this->blue=blue;
    }
    
Color::Color(float red, float green, float blue){
    this->red=(int) (red*255);
    this->green=(int) (green*255);
    this->blue=(int) (blue*255);
    }
    
    Color::Color(int color){ //0xAABBCC
        this->red=(color>>16) & 0x0000FF;
        this->green=(color>>8) & 0x0000FF;
        this->blue=(color>>0) & 0x0000FF;
        }
    
int Color::floatToColorValue(float value){
    return (int) (value*MAX_COLOR_VALUE);
    }
    
int Color::getRed(){
    return red;
    }

int Color::getGreen(){
    return green;
    }

int Color::getBlue(){
    return blue;
    }    

int Color::getHex(){
    return (red <<16) + (green<<8) + (blue<<0);
    }