// this program updates to the latest firmware a wifly module

#include "mbed.h"
#include "WiflyInterface.h"

WiflyInterface wifly(p9, p10, p30, p29, "periodic.lab", "", NONE);

int main() {
    bool success = true;

    printf("wifly init\r\n");
    wifly.init(); //Use DHCP

    while(!wifly.connect()) {
        printf("wifly connecting (%s)...\r\n", wifly.getIPAddress());
    }
    
    // once connected, send command to update firmware    
    printf("set ftp address\r\n");
    if (!wifly.sendCommand("set ftp address 0\r", "AOK"))
        success = false;
    printf("set dns name\r\n");
    if (!wifly.sendCommand("set dns name rn.microchip.com\r", "AOK"))
        success = false;
    printf("save\r\n");
    if (!wifly.sendCommand("save\r", "Stor"))
        success = false;
    printf("ftp update\r\n");
    if (!wifly.sendCommand("ftp update \r", "FTP OK", NULL, 30000))
        success = false;
    printf("factory reset\r\n");
    if (!wifly.sendCommand("factory RESET\r"))
        success = false;
    printf("reboot\r\n");
    if (!wifly.sendCommand("reboot\r"))
        success = false;
    
    if (success)
        printf("firmware updated successfully!\r\n");
    else
        printf("ERROR while updating firmware!\r\n");
}
