/* Copyright (C) 2013 David Dollar, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef MACHINECLOUD_H_
#define MACHINECLOUD_H_

#include <stdint.h>
#include "rtos.h"
#include "XBee.h"

typedef void MachineCloudCallback(char *, char *);

class MachineCloudReceiver {
    public:
        virtual void receive(char *, char *) = NULL;
};

class MachineCloud {

    public:

        // constructor
        MachineCloud();
        MachineCloud(uint16_t router);
        
        // connect to the machine cloud
        int connect();
        int disconnect();

        // receive callback
        int on_receive(MachineCloudCallback *function);
        int on_receive(MachineCloudReceiver *object);
        
        // send a message   
        int send(char *key, char *value);
        
        // runloop
        int loop();
                
    private:
        
        void init(uint16_t router);
        void receive(char *key, char *value);
        
        Mutex m_lock;
        MachineCloudCallback *m_receiverFunction;
        MachineCloudReceiver *m_receiverObject;
        uint16_t m_router;
        XBee *m_xbee;
};

#endif /* MACHINECLOUD_H_ */