#include <string.h>
#include "MachineCloud.h"

MachineCloud::MachineCloud() {
    init(0x1000);
}

MachineCloud::MachineCloud(uint16_t router) {
    init(router);
}

void MachineCloud::init(uint16_t router) {
    m_router = router;
}

int MachineCloud::connect() {
    m_xbee = new XBee(p9, p10);
    return 0;
}

int MachineCloud::disconnect() {
    m_xbee = NULL;
    return 0;
}

int MachineCloud::on_receive(MachineCloudCallback *function) {
    m_receiverFunction = function;
    m_receiverObject   = NULL;
    return 0;
}

int MachineCloud::on_receive(MachineCloudReceiver *object) {
    m_receiverFunction = NULL;
    m_receiverObject   = object;
    return 0;
}

int MachineCloud::send(char *key, char *value) {
    m_lock.lock();
    
    int size = strlen(key) + strlen(value) + 1;
    char *message = (char *)malloc(size);
    sprintf(message, "%s=%s", key, value);

    uint8_t payload[size];
    for (int i=0; i<size; i++) {
        payload[i] = message[i];
    }
    
    free(message);
    
    TxStatusResponse txStatus = TxStatusResponse();
    Tx16Request tx = Tx16Request(m_router, payload, sizeof(payload));
    m_xbee->send(tx);
    
    m_lock.unlock();
    
    return 0;
}

void MachineCloud::receive(char *key, char *value) {
    if (m_receiverFunction) (*m_receiverFunction)(key, value);
    if (m_receiverObject) m_receiverObject->receive(key, value);
}

Rx16Response rx16 = Rx16Response();

int MachineCloud::loop() {
    m_xbee->readPacket();
    
    if (m_xbee->getResponse().isAvailable()) {
        switch (m_xbee->getResponse().getApiId()) {
            case RX_16_RESPONSE:
                Rx16Response rx16 = Rx16Response();
                m_xbee->getResponse().getRx16Response(rx16);
                char *data = (char *)malloc(rx16.getDataLength() + 1);
                for (int i=0; i<rx16.getDataLength(); i++) {
                    data[i] = rx16.getData(i);
                }
                data[rx16.getDataLength()] = 0;
                char *key = strtok(data, "=");
                char *val = strtok(NULL, "=");
                receive(key, val);
                free(data);
        }
    }
    

    return 0;
}