#include "mbed.h"


DigitalOut myled(LED1);
DigitalOut led(LED2);
DigitalOut led2(LED3);
DigitalOut led3(LED4);
const int N=1024;  // Sample number
struct TWIDDLE {  // Structure factor for calculate fft

    float cosval [N/2];
    float sinval [N/2];

};
void FFT(float datos[N], int n, TWIDDLE &w); //Declaration of functions
void enviodatos(float datos[N], int n);
Serial pc(USBTX, USBRX);  //Declaration Serial port

int main() {        //Main program
    myled.write(0);
    led.write(0);
    led2.write(0);
    led3.write(0);
    int i;        //Parameters to calculate the values of a sine function. DATOS[N]=Amp*sin(w0*t)
    float arg;
    arg=2*3.1416/N; //argument of the structure TWIDDLE
    float tm,t,w0,T, Amp;
    tm=0.1; // increments of time (0,1seg)
    t=0; //initial time
    T=2*3.1416; //Period of signal
    w0=(2*3.1416/T); // angular frequency
    Amp=3;  //Amplitude
    struct TWIDDLE W; //Declarate of a type structure

    for (i=0; i<N/2; i++) { //Calculate all the TWIDDLE factors
        W.cosval[i]= cos(i*arg);
        W.sinval[i]= -sin(i*arg);
    }

    float DATOS[N]; //array to save the sinus values
    for (i=0; i<N; i++) { //calculate the sinus values
        DATOS[i]=Amp*sin(w0*t);
        t+=tm;
    }
    led.write(1); //Execution of the program to here OK
    FFT(DATOS,N,W); //Function to calculate FFT
    enviodatos(DATOS,N); //Function to send values to serial port
    led3.write(1); //Execution of the program to here OK
    while (1); //

}

void FFT(float datos[N], int n,TWIDDLE &w) {
    float temp1, temp2, temp3,temp4;   //variables needed to calculate FFT
    int i,j,k,p;
    int upper_leg, lower_leg;
    int leg_diff;
    int num_stages=0;
    int index, step;
    float datos_real[n], datos_imag[n]; //real and imaginary values
    for (p=0; p<n; p++) {
        datos_real[p]=datos[p];
        datos_imag[p]=0;
    }
    led2.write(1); // Execution of the program to here break it if N=>2048, else OK.
    i=1;
    do {
        num_stages+=1;
        i=i*2;
    } while (i!=n);

    leg_diff=n/2;
    step=1;

    for (i=0; i<num_stages; i++) {
        index=0;
        for (j=0; j<leg_diff; j++) {
            for (upper_leg=j; upper_leg<n; upper_leg+=(2*leg_diff)) {
                lower_leg=upper_leg+leg_diff;

                temp1= (datos_real[upper_leg]+ datos_real[lower_leg]);
                temp2= (datos_real[upper_leg]- datos_real[lower_leg]);
                temp3= (datos_imag[upper_leg]+ datos_imag[lower_leg]);
                temp4= (datos_imag[upper_leg]- datos_imag[lower_leg]);
                datos_real[lower_leg]= (temp2*w.cosval[index])-(temp4*w.sinval[index]);
                datos_imag[lower_leg]= (temp2*w.sinval[index]+temp4*w.cosval[index]);
                datos_real[upper_leg]= temp1;
                datos_imag[upper_leg]= temp3;
            }
            index+=step;
        }
        leg_diff=leg_diff/2;
        step*=2;
    }
//bit reversal

    j=0;
    for (i=1; i<(N-2); i++) {
        k=n/2;
        while (k<=j) {
            j=j-k;
            k=k/2;
        }
        j=j+k;

        if (i<j) {
            temp1= datos_real[j];
            temp2= datos_imag[j];
            datos_real[j]=datos_real[i];
            datos_imag[j]=datos_imag[i];
            datos_real[i]=temp1;
            datos_imag[i]=temp2;
        }
    }

    for (i=0; i<n; i++) {

        datos[i]= pow(sqrt(pow(datos_real[i],2)+pow(datos_imag[i],2)),2); //Calculate the power fft
    };

}

void enviodatos(float datos[N],int n) {
    int i=0,j=0,k=0,aux=0; //send to serial port the values correctly.
    unsigned char bytes[4];
    float dato;

    for (i=0; i<n; i++) {
        dato=datos[i];
        aux=dato;
        for (j=0; j<4; j++) {
            switch (j) {
                case 0:
                    bytes[j]=aux;
                    aux=aux>>8;
                    break;
                case 1:
                    bytes[j]=aux;
                    aux=aux>>8;
                    break;
                case 2:
                    bytes[j]=aux;
                    aux=aux>>8;
                    break;
                case 3:
                    bytes[j]=aux;
                    aux=aux>>8;
                    break;
            }
        }
        for (k=3; k>=0; k--) {

            while (pc.writeable()==0);
            pc.putc(bytes[k]);

        }
    }
}