// The purpose of this file and associated header file is to 
// enable globalization of mbed platform specific objects
// for all source files to utilize

#include "mbed_objects.h"

//******************************
// MBED Library instatiations 
//******************************

I2C i2c(I2C_SDA, I2C_SCL);
Serial pc(USBTX, USBRX);

DigitalIn DRDY_PIN(D8);

// MBED native READ/ WRITE functions
unsigned int rm3100_i2c_write(char registerAddress, char* buffer, short int length)
{
    char writeBuffer[MAX_I2C_WRITE + 1];
    writeBuffer[0] = registerAddress;
    memcpy(&writeBuffer[1], buffer, length);
    //i2c.write(RM3100_I2C_ADDRESS_8bit, const char *data, int length, 1);
    // returns 0 on success (ack), non-0 on failure (nack)
    int status = i2c.write(RM3100_I2C_ADDRESS_8bit, writeBuffer, length+1, 0);
    return !status; // return True if successfull. mbed:0=Success
}

unsigned int rm3100_i2c_read(char registerAddress, char* buffer, short int length)
{
    char writeBuffer[1] = {registerAddress};
    i2c.write(RM3100_I2C_ADDRESS_8bit, writeBuffer, 1, 1);
    int status = i2c.read(RM3100_I2C_ADDRESS_8bit, buffer, length, 0);
    if (!status) //mbed:0=Success
        return length;
    else
        return 0;
}
