/**
* @file		   main.cpp
*
* @brief	   Sample code for RM3100.
* @authors     Betty Zhang, Daniel Delsuc
* @date        03/03/2017
* @copyright   (C) 2017 PNI Corp
*
* @copyright   This sample code is provided "as is" without express or implied warranty.
*
*/

// Note: This program assumes the RM3100 is connected using the I2C Interface

#include "main.h"

// Check if DRDY was triggered
bool DataReady()
{
	if (DRDY_PIN == 1)
		return true;
	else
		return false;
}

int main()
{
	pc.baud(115200);
	int dataInCount[3];
	float x, y, z;

	mag_initialize_sensor();

	mag_set_sample_rate(100); //100Hz

	mag_set_power_mode(SensorPowerModeActive);

	//while (!DataReady()); //wait here, if using DRDY Int
	//If not using DRDY, user can check status Reigster 0x34 for dataready.

	//From User Manual Table 3-1 : Geomagnetic Sensor Performance
	//50 CycleCount  ~ 20 LSB/uT
	//100 CycleCount ~ 38 LSB/uT
	//200 CycleCount ~ 75 LSB/uT
	//Linear equation: gain (LSB/uT) = (0.3671 * CycleCount + 1.5)

	int CycleCount = CCP0 | (CCP1 << 8);
	float gain = 0.3671 * CycleCount + 1.5;

	while(1)
	{
		//Get sample data in counts
		mag_get_sample_data((int*)&dataInCount);
		
		while (!DataReady()); //wait here, if using DRDY Int
	
		//Convert to uT
		x = (float)dataInCount[0] / gain;
		y = (float)dataInCount[1] / gain;
		z = (float)dataInCount[2] / gain;
		
		pc.printf("X: %f, Y: %f, Z: %f\n", x, y, z);
		//wait(1);
	}
	return 0;
}