#include "mbed.h"
#include "QEI.h"

// Initialize motor PWM signal period and pulsewidth
PwmOut speed(p22);
DigitalIn  SetSpeed(p20);
Timer t;
QEI encoder (p29, p30, NC, 18);
Serial pc(USBTX, USBRX); // tx, rx

int main() {

// Initialize motor PWM signal period and pulsewidth
    speed.period_us(100000);                                //Experimented to find these numbers
    speed.pulsewidth_us(10000);

// Start motor forward at 25% speed
        int s; s = 25000;
        speed.pulsewidth_us(s);

// Aquire set point from user
        int DutyCycle;
        while ( (DutyCycle < 25) || (DutyCycle > 100) ){     // Experimented to determine this range
            pc.printf("Enter a desired duty cycle between 25%% and 90%% as an interger.\n\n");
            pc.scanf("%i", &DutyCycle);
        }
        
        pc.printf("Duty cycle set to %i%%\n\n", DutyCycle);
        s = (DutyCycle * 1000);   
        speed.pulsewidth_us(s);
        wait(1);

// Motor RPM average initialization and index
        float rpm[5] = {0.0, 0.0, 0.0, 0.0, 0.0};
        int i; i = 0;
        
// Start program loop
   while(1) {

// Index and reset Motor Average Counter
        if(i > 4)
           i = 0;
                           
// Revolutions per minute
        t.start();
          encoder.reset();                             // requires 1_us to execute
          wait_ms(100);                                // requires 9.062_ms to execute
          int pulse10ms = encoder.getPulses();         // requires 3.152 ms to execute for small numbers of pulses (i.e. < 10,000
        t.stop();  
          pc.printf("Pulses Count is %i in %f ms\n", pulse10ms, t.read()*1000);    // requires 13.542 ms to excute
          rpm[i] = (60*pulse10ms)/(2*18*t.read());
          float avgrpm = (rpm[0] + rpm[1] + rpm[2] + rpm[3] + rpm[4]) / 5 ;
          pc.printf("Motor RPM %i= %f\n   AVGRPM  = %f\n\n", i, rpm[i], avgrpm);
          ++i;
        t.reset();
          wait(1);

/* Speed Control of Motor  ****(CHANGE TO LINE COMMENT TO ADD SPEED CONTROL)******

// Build DC Motor Table and enter values into variables on the next line
        
        int rpm20 = , rpm100 = , rpm60 = , rpm70 = , dcY = , rpmLimit = 250;
        int SetSpeed; 
        static int j = 1;
        
        if(j > 0){
            while ( (SetSpeed < rpm60) || (SetSpeed > rpm70) ){   
                pc.printf("Enter a desired RPM between %i and %i as an interger.\n", rpm60, rpm70);
                pc.scanf("%i", &SetSpeed);
                pc.printf("RPM Set Point= %i rpm \n\n", SetSpeed);
                DutyCycle = (80 * SetSpeed / (rpm100 - rpm20)) - dcY;   // y = m*x + b (linear motor curve
                pc.printf("Approx Duty Cycle = %i us \n", DutyCycle);
                s = (DutyCycle * 1000);
                pc.printf("Inital Pulse Width = %i us \n\n", s);
                wait(2);
            }
        }
        j = 0;
        if ( avgrpm < (SetSpeed - rpmLimit)) {
            DutyCycle = (DutyCycle + 1);
            s = (DutyCycle * 1000);
            pc.printf("Increase Duty Cycle= %i%%\n", DutyCycle);
            pc.printf("Pulse Width = %i us \n\n", s);
            speed.pulsewidth_us(s);
            }
        else if ( avgrpm > (SetSpeed + rpmLimit)){
            DutyCycle = (DutyCycle - 1);
            s = (DutyCycle*1000);
            pc.printf("Decrease Duty Cycle= %i%%\n", DutyCycle);
            pc.printf("Pulse Width = %i us \n\n", s);
            speed.pulsewidth_us(s);
            }
        else if ( (avgrpm > (SetSpeed - rpmLimit)) || (avgrpm < (SetSpeed + rpmLimit)) ) {
            s = DutyCycle * 1000;
            pc.printf("Stable Duty Cycle= %i%%\n", DutyCycle);
            pc.printf("Pulse Width = %i us \n\n", s);
            }
        else
            
    return 0;                                                                              
     
*/ //****(CHANGE TO LINE COMMENT TO ADD SPEED CONTROL) 
    
    }       
}
