//---------------------------------------------------------------
//
//  Demo program for 
//  F469_Button and Slider library
//
//---------------------------------------------------------------
#include "mbed.h"
#include "F469_BUTTON.hpp"
#include "F469_SLIDER.hpp"

DigitalOut led_green(LED1);
DigitalOut led_orange(LED2);
DigitalOut led_red(LED3);
DigitalOut led_blue(LED4);

TS_DISCO_F469NI ts_;
LCD_DISCO_F469NI lcd_;


char char_SliderDisplayValue[4];    // String Value to display for the Slider Control value 
uint16_t SliderDisplayValue_;       // Variable used to access Slider Control Value in F469SLIDER.cpp

int main()
{
    led_green = 1;         // Switch off all LEDs
    led_orange = 1;
    led_red = 1;
    led_blue = 1; 

    lcd_.Clear(LCD_COLOR_WHITE);                                        // Set LCD Background colour
   
  //  Slider sld1(lcd_, ts_, 20, 350, 220, 40, 5, 1, 20,      
  //               LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 1, "Slider1", Font20);   // Define sld1 slider            
   // sld1.Render();                                                          // Draw sld1 Slider  
   
  //  Slider Slider2(lcd_, ts_, 300, 350, 300, 40, 50, 1, 100,      
  //               LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "Slider2", Font20);   // Define Slider2 slider            
  //  Slider2.Render();                                                       // Draw Slider2 Slider      
       
   Button btn1(lcd_, ts_, 20, 100, 120, 60,            
              LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 1, "BUTTON1", Font20);  // Define btn1 button            
   btn1.Render();                                                         // Draw btn1 button
    
    Button btn2(lcd_, ts_, 160, 100, 120, 60,
                 LCD_COLOR_DARKBLUE, LCD_COLOR_GREEN, 1, "BUTTON2", Font20);  // Define test button                   
    btn2.Render();                                                         // Draw test button
    
  //  Button show(lcd_, ts_, 300, 100, 120, 60,            
  //               LCD_COLOR_BROWN, LCD_COLOR_GRAY, 1,  "SHOW", Font20);     // Define hide button            
  //  show.Hide();  
    
  //  Button hide(lcd_, ts_, 300, 100, 120, 60,            
  //               LCD_COLOR_BROWN, LCD_COLOR_GRAY, 1,  "HIDE", Font20);     // Define hide button             
  //  hide.Render();                                                         // Draw hide button
    
   // Button button3D(lcd_, ts_, 580, 100, 160, 60,            
   //              LCD_COLOR_BLUE, LCD_COLOR_YELLOW, 2, "3D BUTTON", Font20);    // Define button3D button            
   // button3D.Render();                                                         // Draw 3Dbutton button



    lcd_.SetTextColor(LCD_COLOR_BLACK);                                                         // Set Text colour to Black
    lcd_.SetFont(&Font20);                                                                      // Font size 20
    lcd_.DisplayStringAt(5, 5, (uint8_t *)"Button example for DISCO_F469", LEFT_MODE);  // Display main header text

    lcd_.SetFont(&Font16);                                                                      // Font size 16
    lcd_.DisplayStringAt(5, 45, (uint8_t *)"More text", LEFT_MODE);                        // Display secondary header text


    while (true)                                                    // Main program loop
    {
        led_green = 1;                                              // Switch off all LEDs
        led_orange = 1;
        led_red = 1;
        led_blue = 1; 
        

    
        

    
    
    
        if (btn1.Press())                                         // Check if btn1 button was touched and run instructions if true
        {    
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 200, (uint8_t *)"Button1 pressed - switch on orange LED", LEFT_MODE);
            led_orange = 0; 
            wait(0.5); 
            lcd_.DisplayStringAt(5, 200, (uint8_t *)"                                        ", LEFT_MODE);
        }                                                           // End btn1 button instructions
        
        if (btn2.Press())                                         // Check if test button was touched and run instructions if true
        {
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 200, (uint8_t *)"TEST pressed - switch on red LED", LEFT_MODE);
            led_red = 0;
            wait(0.5);
            lcd_.DisplayStringAt(5, 200, (uint8_t *)"                                        ", LEFT_MODE);
            
        }                                                           // End test button instructions
        
  /*      if (hide.Press())                                         // Check if hide button was touched and run instructions if true
        {    
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 200, (uint8_t *)"Hide pressed - Hide other buttons", LEFT_MODE);
            led_green = 0;
            btn1.Hide();                                            // Hide btn1 button
            test.Hide();                                            // Hide test button
            hide.Hide();  
            show.Render();
            wait(0.5);
            lcd_.DisplayStringAt(5, 200, (uint8_t *)"                                        ", LEFT_MODE);
        }                                                           // End hide button instructions

        
         if (show.Press())                                        // Check if hide button was touched and run instructions if true
        {  
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 200, (uint8_t *)"UNHIDE pressed - Restore other buttons", LEFT_MODE);
            led_blue = 0; 
            wait(0.5);
            lcd_.DisplayStringAt(5, 200, (uint8_t *)"                                        ", LEFT_MODE);
            show.Hide();                                            // Hide show button before drawing new button in same place
            hide.Render();                                            // Draw hide button after hiding button in same position
            btn1.Render();                                            // Draw btn1 button
            test.Render();                                            // Draw test button
            
        }         
        
        if (button3D.Press())                                     // Check if 3Dbutton button was touched and run instructions if true
        {    
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_BLACK);
            lcd_.DisplayStringAt(5, 200, (uint8_t *)"3D Button pressed - switch on blue LED", LEFT_MODE);
            led_blue = 0;
            wait(0.5);
            lcd_.DisplayStringAt(5, 200, (uint8_t *)"                                           ", LEFT_MODE);
        }                                                           // End 3D button instructions
*/
        wait(0.02f);   
    }                                                               // End Main program loop
}                                                                   // End Main program 
