//-----------------------------------------------------------
//
//  F469_BUTTON class
//
//-----------------------------------------------------------

#include "F469_BUTTON.hpp"

// Draw button
void Button::Render()
    {
        active_ = true;
        
        switch(STYLE_)
            {
                case 1:                                     // Style 1 - Normal button 
                    lcd_.SetTextColor(BUTTON_COLOUR_);      // Set Textcolour to original
                    lcd_.FillRect(ButtonX_, ButtonY_, ButtonW_, ButtonH_);  // Draw button rectangle
                    break;
        
                case 2:                                     // Style 2 - 3D button
                    lcd_.SetTextColor(LCD_COLOR_DARKGRAY);  // Set Textcolour to shadow colour
                    lcd_.FillRect(ButtonX_+1, ButtonY_+2, (ButtonW_+3), ButtonH_+3);// Draw shadow
                    
                    lcd_.SetTextColor(BUTTON_COLOUR_);      // Set Textcolour to original
                    lcd_.FillRect(ButtonX_, ButtonY_, ButtonW_, ButtonH_);  // Draw button
                    break; 
            }  
             if (LABEL_.length() != 0)                        // If the label is larger than 0
                    {
                        lcd_.SetFont(FONTS_);
                        lcd_.SetBackColor(BUTTON_COLOUR_);    // Set background colour
                        lcd_.SetTextColor(LCD_COLOR_WHITE);   // Set textcolour

                        uint16_t x0 = ButtonX_ + (ButtonW_ - FONT_WIDTH_*(LABEL_.length()))/2;      // Calcukate x value for Button name
                        uint16_t y0 = ButtonY_ + (ButtonH_ - FONT_HEIGHT_)/2 + 1;                   // Calcukate y value for Button name
                        lcd_.DisplayStringAt(x0, y0, (uint8_t *)LABEL_.c_str(),   
                                 LEFT_MODE);                    // Write button name
                        lcd_.SetBackColor(LCD_COLOR_WHITE);     // Set back colour
                    }        
    }
    

void Button::Change()   // Change colour of button when pressed
    {
        switch(STYLE_)
            {
                case 1:                                     // Style 1 - Normal button 
                    lcd_.SetTextColor(CHANGE_COLOUR_);      // Set Textcolour to the change colour
                    lcd_.FillRect(ButtonX_, ButtonY_, ButtonW_, ButtonH_);          // Draw button rectangle
                    break;
        
                case 2:                                     // Style 2 - 3D button
                    lcd_.SetTextColor(LCD_COLOR_WHITE);     // Set Textcolour to background colour
                    lcd_.FillRect(ButtonX_, ButtonY_, (ButtonW_+3), ButtonH_+3);    // Clears background
    
                    lcd_.SetTextColor(LCD_COLOR_GRAY);      // Set Textcolour to shadow colour
                    lcd_.FillRect(ButtonX_+1, ButtonY_+2, (ButtonW_+3), ButtonH_+3);// Draws shadow
        
                    lcd_.SetTextColor(CHANGE_COLOUR_);      // Indent button
                    lcd_.FillRect((ButtonX_+6), (ButtonY_+6), (ButtonW_-3), (ButtonH_-2));  // Draw indented button
                    break; 
                }         
        
             if (LABEL_.length() != 0)            
                    {
                        lcd_.SetFont(FONTS_);
                        lcd_.SetBackColor(CHANGE_COLOUR_);
                        lcd_.SetTextColor(LCD_COLOR_BLACK);
                        uint16_t x0 = ButtonX_ + (ButtonW_ - FONT_WIDTH_*(LABEL_.length()))/2;  // Calcukate x value for Button name
                        uint16_t y0 = ButtonY_ + (ButtonH_ - FONT_HEIGHT_)/2 + 1;               // Calcukate y value for Button name
                        lcd_.DisplayStringAt(x0, y0, (uint8_t *)LABEL_.c_str(),
                                 LEFT_MODE);                // Write button name 
                        lcd_.SetBackColor(LCD_COLOR_WHITE); // Set back colour
                    }          
    }
    
        

void Button::Hide()     // Hide button
    {
        lcd_.SetTextColor(LCD_COLOR_WHITE);                     // Set textcolour to background colour
        lcd_.FillRect(ButtonX_, ButtonY_, ButtonW_, ButtonH_);  // Draw rectangle in background colour     
        active_ = false;                                        // Set active boolean to false
    }
      

bool Button::Press()      // Check if touch detected
    {
        ts_.GetState(&state_);
        if (!state_.touchDetected) return false;
        if (!active_) return false;
        if (!ButtonBoundaryCheck()) return false;
        Change();           // Run the Change routine to change the colour of the button
        wait(0.2);          // Wait to allow the colour change to be visible
        Render();           // Draw the original button
        return true;
    } 

bool Button::ButtonBoundaryCheck()       // Check if touch is within button boundaries
    {
        int nTouch = multiTouch ? state_.touchDetected : 1;
        for (int n=0; n<nTouch; n++)
        {
            uint16_t x = state_.touchX[n];                  // Assign touch x pos to x
            uint16_t y = state_.touchY[n];                  // Assign touch y pos to y

            if ( (ButtonX_ <= x) && (x <= ButtonX_+ButtonW_) &&               // Check x value inside boundary
                 (ButtonY_ <= y) && (y <= ButtonY_+ButtonH_) ) return true;   // Check y value inside boundary
        }
        return false;
    }
    
TS_StateTypeDef Button::state_;
bool Button::multiTouch = false;

