#include "mbed.h"
#include "uLCD_4DGL.h"
#include "Speaker.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include <iostream>




DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalIn  select(p19);
DigitalIn  move(p20);
DigitalIn  clear(p23);  // clear the piece manually

uLCD_4DGL uLCD(p28,p27,p30);
SDFileSystem sd(p11, p12, p13, p17, "sd");
AnalogOut DACout(p18);

wave_player waver(&DACout);

int x1_start = 8;
int y1_start = 8;
int x2_start = 21;
int y2_start = 21;
int x1_r2 = 22;
int y1_r2 = 22;
int x2_r2 = 35;
int y2_r2 = 35;

int p1_x = 15;
int p1_y = 15;
int p2_x = 112;
int p2_y = 112;
int r = 4;

int row [8];
int col [8];


class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();
//boolean functions to test each switch
    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();
//automatic read on RHS
    operator int ();
//index to any switch array style
    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;
 
};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
    wait(0.001); //delays just a bit for pullups to pull inputs high
}
inline bool Nav_Switch::up()
{
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}
 
Nav_Switch myNav( p9, p6, p7, p5, p8); //pin order on Sparkfun breakout

class Game_Cursor
{
    int x_, y_, r_, p_,n_,ID_,status_;
    
public:
    void set_values (int,int,int);
    void set_color (int);
    void set_n (int);
    void draw_cursor();
    void set_ID(int);
    void set_status(int);
    int get_x() { return x_;}
    int get_y() { return y_;}
    int get_r() { return r_;}   
    int get_p() { return p_;}
    int get_n(){ return n_;}
    int get_ID() { return ID_;}
    int get_status() {return status_;}
    
};

void Game_Cursor::set_values (int x, int y, int r)
{
    x_ = x;
    y_ = y;
    r_ = r;
}

void Game_Cursor::set_color (int p)
{
    p_ = p;
}

void Game_Cursor::set_n(int n)
{
    n_ = n;
}
    
void Game_Cursor::draw_cursor()
{
    uLCD.circle(x_,y_,r_,p_);
}
void Game_Cursor::set_ID (int ID)
{
    ID_ = ID;
}
void Game_Cursor::set_status (int status)
{
    status_ = status;
}
class Game_Piece
{
    int x_,y_,r_,p_,ID_;
public:
    void set_values (int,int,int,int);
    void set_ID(int);
    int get_x() { return x_;}
    int get_y() { return y_;}
    int get_r() {
        return r_;
    }
    int get_p() {
        return p_;
    }
    int get_ID() {
        return ID_;
    }    
};

void Game_Piece::set_values (int x, int y, int r, int p)
{
    x_ = x;
    y_ = y;
    r_ = r;
    p_ = p;
}

void Game_Piece::set_ID (int ID)
{
    ID_ = ID;
}    

class Game_Cell
{
    int x_,y_,color_,status_,n_,ID_;
    public:
    void set_values(int,int,int);
    void set_status(int);
    void set_n(int);
    void set_ID(int);
    int get_x(){ return x_;}
    int get_y(){ return y_;}
    int get_color(){ return color_;}
    int get_status(){ return status_;}
    int get_n(){ return n_;}
    int get_ID(){ return ID_;}
};
void Game_Cell::set_values(int x, int y, int color)
{
    x_ = x;
    y_ = y;
    color_=color;
}

void Game_Cell::set_status(int status)
{
    status_ = status;
}  

void Game_Cell::set_n(int n)
{
    n_ = n;
}

void Game_Cell::set_ID(int ID)
{
    ID_ = ID;
}    
          
int main()
{
    int player_1_pieces = 12;
    int player_2_pieces = 12;

    row[0]=15;
    col[0]=15;
    for(int i=1; i<8; i++) {
        row[i]=row[i-1]+14;
        col[i]=col[i-1]+14;
    }

    while(1) {
       // uLCD.background_color(BLUE);
        uLCD.cls();
        //uLCD.printf("Player 1");
        
        Game_Piece p1_[12];
        Game_Piece p2_[12];
        
        Game_Cell cell[64];
        
         // Player One Pieces
        p1_[0].set_values(row[0],col[0],r,BLACK);
        p1_[0].set_ID(1);
        p1_[1].set_values(row[2],col[0],r,BLACK);
        p1_[1].set_ID(2);
        p1_[2].set_values(row[4],col[0],r,BLACK);
        p1_[2].set_ID(3);
        p1_[3].set_values(row[6],col[0],r,BLACK);
        p1_[3].set_ID(4);
        p1_[4].set_values(row[1],col[1],r,BLACK);
        p1_[4].set_ID(5);
        p1_[5].set_values(row[3],col[1],r,BLACK);
        p1_[5].set_ID(6);
        p1_[6].set_values(row[5],col[1],r,BLACK);
        p1_[6].set_ID(7);
        p1_[7].set_values(row[7],col[1],r,BLACK);
        p1_[7].set_ID(8);
        p1_[8].set_values(row[0],col[2],r,BLACK);
        p1_[8].set_ID(9);
        p1_[9].set_values(row[2],col[2],r,BLACK);
        p1_[9].set_ID(10);
        p1_[10].set_values(row[4],col[2],r,BLACK);
        p1_[10].set_ID(11);
        p1_[11].set_values(row[6],col[2],r,BLACK);
        p1_[11].set_ID(12);
        
        // Player Two Pieces
        p2_[0].set_values(row[1],col[5],r,RED);
        p2_[0].set_ID(13);
        p2_[1].set_values(row[3],col[5],r,RED);
        p2_[1].set_ID(14);
        p2_[2].set_values(row[5],col[5],r,RED);
        p2_[2].set_ID(15);
        p2_[3].set_values(row[7],col[5],r,RED);
        p2_[3].set_ID(16);
        p2_[4].set_values(row[0],col[6],r,RED);
        p2_[4].set_ID(17);
        p2_[5].set_values(row[2],col[6],r,RED);
        p2_[5].set_ID(18);
        p2_[6].set_values(row[4],col[6],r,RED);
        p2_[6].set_ID(19);
        p2_[7].set_values(row[6],col[6],r,RED);
        p2_[7].set_ID(20);
        p2_[8].set_values(row[1],col[7],r,RED);
        p2_[8].set_ID(21);
        p2_[9].set_values(row[3],col[7],r,RED);
        p2_[9].set_ID(22);
        p2_[10].set_values(row[5],col[7],r,RED);
        p2_[10].set_ID(23);
        p2_[11].set_values(row[7],col[7],r,RED);
        p2_[11].set_ID(24);
        
        // row one cells 0 - 7
        cell[0].set_values(15,15,WHITE);
        cell[0].set_status(1);
        cell[0].set_n(0);
        cell[0].set_ID(p1_[0].get_ID());
        cell[1].set_values(29,15,0x999999);
        cell[1].set_status(0);
        cell[1].set_n(1);
        cell[1].set_ID(0);
        cell[2].set_values(43,15,WHITE);
        cell[2].set_status(1);
        cell[2].set_n(2);
        cell[2].set_ID(p1_[1].get_ID());
        cell[3].set_values(57,15,0x999999);
        cell[3].set_status(0);
        cell[3].set_n(3);        
        cell[3].set_ID(0);
        cell[4].set_values(71,15,WHITE);
        cell[4].set_status(1);
        cell[4].set_n(4);
        cell[4].set_ID(p1_[2].get_ID());
        cell[5].set_values(85,15,0x999999);
        cell[5].set_status(0);
        cell[5].set_n(5);
        cell[5].set_ID(0);
        cell[6].set_values(99,15,WHITE);
        cell[6].set_status(1);
        cell[6].set_n(6);
        cell[6].set_ID(p1_[3].get_ID());
        cell[7].set_values(113,15,0x999999);
        cell[7].set_status(0);
        cell[7].set_n(7);
        cell[7].set_ID(0);
        
       // row two cells 8 through 15
        cell[8].set_values(15,29,0x999999);
        cell[8].set_status(0);
        cell[8].set_n(8);
        cell[8].set_ID(0);
        cell[9].set_values(29,29,WHITE);
        cell[9].set_status(1);
        cell[9].set_n(9);
        cell[9].set_ID(p1_[4].get_ID());
        cell[10].set_values(43,29,0x999999);
        cell[10].set_status(0);
        cell[10].set_n(10);
        cell[10].set_ID(0);
        cell[11].set_values(57,29,WHITE);
        cell[11].set_status(1); 
        cell[11].set_n(11);
        cell[11].set_ID(p1_[5].get_ID());       
        cell[12].set_values(71,29,0x999999);
        cell[12].set_status(0);
        cell[12].set_n(12);
        cell[12].set_ID(0);
        cell[13].set_values(85,29,WHITE);
        cell[13].set_status(1);
        cell[13].set_n(13);
        cell[13].set_ID(p1_[6].get_ID());
        cell[14].set_values(99,29,0x999999);
        cell[14].set_status(0);
        cell[14].set_n(14);
        cell[14].set_ID(0);
        cell[15].set_values(113,29,WHITE);
        cell[15].set_status(1);
        cell[15].set_n(15);
        cell[15].set_ID(p1_[7].get_ID());
        
        //row three cells 16 - 23
        cell[16].set_values(15,43,WHITE);
        cell[16].set_status(1);
        cell[16].set_n(16);
        cell[16].set_ID(p1_[8].get_ID());
        cell[17].set_values(29,43,0x999999);
        cell[17].set_status(0);
        cell[17].set_n(17);
        cell[17].set_ID(0);
        cell[18].set_values(43,43,WHITE);
        cell[18].set_status(1);
        cell[18].set_n(18);
        cell[18].set_ID(p1_[9].get_ID());
        cell[19].set_values(57,43,0x999999);
        cell[19].set_status(0); 
        cell[19].set_n(19);
        cell[19].set_ID(0);       
        cell[20].set_values(71,43,WHITE);
        cell[20].set_status(1);
        cell[20].set_n(20);
        cell[20].set_ID(p1_[10].get_ID());
        cell[21].set_values(85,43,0x999999);
        cell[21].set_status(0);
        cell[21].set_n(21);
        cell[21].set_ID(0);
        cell[22].set_values(99,43,WHITE);
        cell[22].set_status(1);
        cell[22].set_n(22);
        cell[22].set_ID(p1_[11].get_ID());
        cell[23].set_values(113,43,0x999999);
        cell[23].set_status(0);
        cell[23].set_n(23);
        cell[22].set_ID(0);
        
        // row four cells 24 - 31
        cell[24].set_values(15,57,0x999999);
        cell[24].set_status(0);
        cell[24].set_n(24);
        cell[24].set_ID(0);
        cell[25].set_values(29,57,WHITE);
        cell[25].set_status(0);
        cell[25].set_n(25);
        cell[25].set_ID(0);
        cell[26].set_values(43,57,0x999999);
        cell[26].set_status(0);
        cell[26].set_n(26);
        cell[26].set_ID(0);
        cell[27].set_values(57,57,WHITE);
        cell[27].set_status(0); 
        cell[27].set_n(27);
        cell[27].set_ID(0);       
        cell[28].set_values(71,57,0x999999);
        cell[28].set_status(0);
        cell[28].set_n(28);
        cell[28].set_ID(0);
        cell[29].set_values(85,57,WHITE);
        cell[29].set_status(0);
        cell[29].set_n(29);
        cell[29].set_ID(0);
        cell[30].set_values(99,57,0x999999);
        cell[30].set_status(0);
        cell[30].set_n(30);
        cell[20].set_ID(0);
        cell[31].set_values(113,57,WHITE);
        cell[31].set_status(0);
        cell[31].set_n(31);
        cell[31].set_ID(0); 
        
        // row five cells 32 - 39
        cell[32].set_values(15,71,WHITE);
        cell[32].set_status(0);
        cell[32].set_n(32);
        cell[32].set_ID(0);
        cell[33].set_values(29,71,0x999999);
        cell[33].set_status(0);
        cell[33].set_n(33);
        cell[33].set_ID(0);
        cell[34].set_values(43,71,WHITE);
        cell[34].set_status(0);
        cell[34].set_n(34);
        cell[34].set_ID(0);
        cell[35].set_values(57,71,0x999999);
        cell[35].set_status(0); 
        cell[35].set_n(35);
        cell[35].set_ID(0);       
        cell[36].set_values(71,71,WHITE);
        cell[36].set_status(0);
        cell[36].set_n(36);
        cell[36].set_ID(0);
        cell[37].set_values(85,71,0x999999);
        cell[37].set_status(0);
        cell[37].set_n(37);
        cell[38].set_values(99,71,WHITE);
        cell[38].set_status(0);
        cell[38].set_n(38);
        cell[38].set_ID(0);
        cell[39].set_values(113,71,0x999999);
        cell[39].set_status(0);
        cell[39].set_n(39);
        cell[29].set_ID(0);   
             
        // row six cells 40 - 47
        cell[40].set_values(15,85,0x999999);
        cell[40].set_status(0);
        cell[40].set_n(40);
        cell[40].set_ID(0);
        cell[41].set_values(29,85,WHITE);
        cell[41].set_status(2);
        cell[41].set_n(41);
        cell[41].set_ID(p2_[0].get_ID());  //
        cell[42].set_values(43,85,0x999999);
        cell[42].set_status(0);
        cell[42].set_n(42);
        cell[42].set_ID(0);
        cell[43].set_values(57,85,WHITE);
        cell[43].set_status(2); 
        cell[43].set_n(43);
        cell[43].set_ID(p2_[1].get_ID());  //     
        cell[44].set_values(71,85,0x999999);
        cell[44].set_status(0);
        cell[44].set_n(44);
        cell[44].set_ID(0);
        cell[45].set_values(85,85,WHITE);
        cell[45].set_status(2);
        cell[45].set_n(45);
        cell[45].set_ID(p2_[2].get_ID());  //
        cell[46].set_values(99,85,0x999999);
        cell[46].set_status(0);
        cell[46].set_n(46);
        cell[46].set_ID(0);
        cell[47].set_values(113,85,WHITE);
        cell[47].set_status(2);
        cell[47].set_n(47);
        cell[47].set_ID(p2_[3].get_ID()); // 
                
        // row seven cells 48 - 55
        cell[48].set_values(15,99,WHITE);
        cell[48].set_status(2);
        cell[48].set_n(48);
        cell[48].set_ID(p2_[4].get_ID());
        cell[49].set_values(29,99,0x999999);
        cell[49].set_status(0);
        cell[49].set_n(49);
        cell[49].set_ID(0);
        cell[50].set_values(43,99,WHITE);
        cell[50].set_status(2);
        cell[50].set_n(50);
        cell[50].set_ID(p2_[5].get_ID());
        cell[51].set_values(57,99,0x999999);
        cell[51].set_status(0); 
        cell[51].set_n(51);
        cell[50].set_ID(0);       
        cell[52].set_values(71,99,WHITE);
        cell[52].set_status(2);
        cell[52].set_n(52);
        cell[52].set_ID(p2_[6].get_ID());
        cell[53].set_values(85,99,0x999999);
        cell[53].set_status(0);
        cell[53].set_n(53);
        cell[53].set_ID(0);
        cell[54].set_values(99,99,WHITE);
        cell[54].set_status(2);
        cell[54].set_n(54);
        cell[54].set_ID(p2_[7].get_ID());
        cell[55].set_values(113,99,0x999999);
        cell[55].set_status(0);
        cell[55].set_n(55);
        cell[55].set_ID(0);
                
        // row eight cells 56 - 64       
        cell[56].set_values(15,113,0x999999);
        cell[56].set_status(0);
        cell[56].set_n(56);
        cell[56].set_ID(0);
        cell[57].set_values(29,113,WHITE);
        cell[57].set_status(2);
        cell[57].set_n(57);
        cell[57].set_ID(p2_[8].get_ID());
        cell[58].set_values(43,113,0x999999);
        cell[58].set_status(0);
        cell[58].set_n(58);
        cell[58].set_ID(0);
        cell[59].set_values(57,113,WHITE);
        cell[59].set_status(2); 
        cell[59].set_n(59);
        cell[59].set_ID(p2_[9].get_ID());       
        cell[60].set_values(71,113,0x999999);
        cell[60].set_status(0);
        cell[60].set_n(60);
        cell[60].set_ID(0); 
        cell[61].set_values(85,113,WHITE);
        cell[61].set_status(2);
        cell[61].set_n(61);
        cell[61].set_ID(p2_[10].get_ID()); 
        cell[62].set_values(99,113,0x999999);
        cell[62].set_status(0);
        cell[62].set_n(62);
        cell[62].set_ID(0); 
        cell[63].set_values(113,113,WHITE);
        cell[63].set_status(2);
        cell[63].set_n(63);
        cell[63].set_ID(p2_[11].get_ID()); 
               
        //Board
        uLCD.filled_rectangle(8, 8, 120, 119, 0x999999);
        uLCD.rectangle(8,8,120,120,BLUE);
        uLCD.filled_rectangle(x1_start,y1_start,x2_start,y2_start, WHITE);
        uLCD.filled_rectangle(x1_r2,y1_r2,x2_r2,y2_r2, WHITE);

        // odd rows
        for(int i = 0; i < 8; i=i+2) {
            uLCD.filled_rectangle(x1_start+14*i,y1_start,x2_start+14*i,y2_start, WHITE);
            uLCD.filled_rectangle(x1_start+14*i,y1_start+28,x2_start+14*i,y2_start+28,WHITE);
            uLCD.filled_rectangle(x1_start+14*i,y1_start+28*2,x2_start+14*i,y2_start+28*2,WHITE);
            uLCD.filled_rectangle(x1_start+14*i,y1_start+28*3,x2_start+14*i,y2_start+28*3,WHITE);
        }
        // even rows
        for(int j = 0; j < 7; j=j+2) {
            uLCD.filled_rectangle(x1_r2+14*j,y1_r2,x2_r2+14*j,y2_r2, WHITE);
            uLCD.filled_rectangle(x1_r2+14*j,y1_r2+28,x2_r2+14*j,y2_r2+28, WHITE);
            uLCD.filled_rectangle(x1_r2+14*j,y1_r2+28*2,x2_r2+14*j,y2_r2+28*2, WHITE);
            uLCD.filled_rectangle(x1_r2+14*j,y1_r2+28*3,x2_r2+14*j,y2_r2+28*3, WHITE);
        }
        uLCD.rectangle(8,8,120,120,BLUE);
      
        
    // draw player one pieces
    for(int k = 0;k<12;k++) {
        uLCD.filled_circle(p1_[k].get_x(),p1_[k].get_y(),p1_[k].get_r(),p1_[k].get_p());
        }
 
    // draw player two pieces
    for(int k = 0;k<12;k++) {
        uLCD.filled_circle(p2_[k].get_x(),p2_[k].get_y(),p2_[k].get_r(),p2_[k].get_p());
        }
        
    Game_Cursor g_c;
    
    g_c.set_values(row[0],col[0],6);
    g_c.set_color(BLUE);
    g_c.set_n(0);
    g_c.draw_cursor();
    g_c.set_ID(0);
    g_c.set_status(0);   
    
    myled3=0;
        
    int location = 0;   
    int timer = 0; 
        while(1) {

            
            if(player_1_pieces < 12) // change 12 back to 1
                {
                    while(1)
                    {
                     uLCD.background_color(WHITE);
                     uLCD.cls();
                     wait(0.2);
                     uLCD.cls();
                     uLCD.locate(4,6);
                     uLCD.background_color(WHITE);
                     uLCD.set_font(FONT_7X8);
                     uLCD.text_mode(TRANSPARENT);
                     uLCD.text_bold(ON);
                     uLCD.text_string("GAME OVER", 4, 6, FONT_7X8, BLUE);
                     uLCD.locate(2,10);
                     uLCD.text_bold(ON);
                     uLCD.text_string("Player 1 Loses", 2, 10, FONT_7X8, RED);
                     uLCD.text_width(4); //4X size text
                     uLCD.text_height(4);
                     uLCD.color(RED);
                     myled1=0;
                     myled2=0;
                     myled3=0;
                     FILE *wave_file;
                     wave_file=fopen("/sd/champ.wav","r");
                     waver.play(wave_file);
                     fclose(wave_file);
                     
                     while(1)
                     {
                         myled2=1;
                         wait(0.2);
                         myled2=0;
                         wait(0.2);
                         }
                     
                     
          
                    }
                }
                
            if(player_2_pieces < 12)  // change 12 back to 1
                {
                    while(1)
                    {
                     uLCD.background_color(BLUE);
                     uLCD.cls();
                     wait(0.2);
                     uLCD.cls();
                     uLCD.locate(4,6);
                     uLCD.background_color(BLUE);
                     uLCD.set_font(FONT_7X8);
                     uLCD.text_mode(TRANSPARENT);
                     uLCD.text_bold(ON);
                     uLCD.text_string("GAME OVER", 4, 6, FONT_7X8, WHITE);
                     uLCD.locate(2,10);
                     uLCD.text_bold(ON);
                     uLCD.text_string("Player 2 Loses", 2, 10, FONT_7X8, WHITE);
                     uLCD.text_width(4); //4X size text
                     uLCD.text_height(4);
                     uLCD.color(RED);
                     myled1=0;
                     myled2=0;
                     myled3=0;
                     FILE *wave_file;
                     wave_file=fopen("/sd/champ.wav","r");
                     waver.play(wave_file);
                     fclose(wave_file);
                     while(1)
                     {
                         myled1=1;
                         wait(0.2);
                         myled1=0;
                         wait(0.2);
                         }
                     
                     
          
                    }
                }
   
            if(select)
            {
 
                if(g_c.get_ID() == 0)
                    {
                    location = g_c.get_n();
                    g_c.set_status(cell[location].get_status());
                    g_c.set_ID(cell[location].get_ID());
                    
                    }

                    
            }
            
            if(move)
            {

               myled3 =1;
                if(g_c.get_ID() > 0)
                {
                  if(cell[g_c.get_n()].get_status() < 1)
                  {
                     int x = g_c.get_x();
                     int y = g_c.get_y();
                     uLCD.filled_circle(cell[location].get_x(),cell[location].get_y(),r,WHITE);
                     if (g_c.get_status() == 1)
                     {
                     uLCD.filled_circle(x,y,r,BLACK);
                     FILE *wave_file;
                     wave_file=fopen("/sd/bang.wav","r");
                     waver.play(wave_file);
                     fclose(wave_file);
                     }
                     else if (g_c.get_status() == 2)
                     {
                     uLCD.filled_circle(x,y,r,RED);
                     FILE *wave_file;
                     wave_file=fopen("/sd/zip.wav","r");
                     waver.play(wave_file);
                     fclose(wave_file);
                     }
                     cell[g_c.get_n()].set_status(cell[location].get_status());
                     cell[location].set_status(0);
                     cell[g_c.get_n()].set_ID(g_c.get_ID());
                     cell[location].set_ID(0);
                     location = 0;
                     g_c.set_ID(0);
                     g_c.set_status(0);
                   
                    myled3 = 0;
                     
                  }

                    
                }    
            }   
            
            if(clear)
            {
             if(cell[g_c.get_n()].get_status() == 1)
                {
                    uLCD.filled_circle(g_c.get_x(),g_c.get_y(),r,WHITE);
                    cell[g_c.get_n()].set_status(0);
                    player_1_pieces--;
                    FILE *wave_file;
                    wave_file=fopen("/sd/wow.wav","r");
                    waver.play(wave_file);
                    fclose(wave_file);
                    
                }
             if(cell[g_c.get_n()].get_status() == 2)
                {
                    uLCD.filled_circle(g_c.get_x(),g_c.get_y(),r,WHITE);
                    cell[g_c.get_n()].set_status(0);
                    player_2_pieces--;
                    FILE *wave_file;
                    wave_file=fopen("/sd/wow.wav","r");
                    waver.play(wave_file);
                    fclose(wave_file);
                }
            }
            
            if(myNav.down()){
                int c = cell[g_c.get_n()].get_color();
                g_c.set_color(c);
                g_c.draw_cursor();
                int i = g_c.get_n()+ 8;
                if(i > 63) {
                    i=0;
                    }
                int x = cell[i].get_x();
                int y = cell[i].get_y();
                g_c.set_n(i);
                g_c.set_values(x,y,6);
                g_c.set_color(BLUE);
                g_c.draw_cursor();
                }
            if(myNav.right()){
                int c = cell[g_c.get_n()].get_color();
                g_c.set_color(c);
                g_c.draw_cursor();
                int i = g_c.get_n()+ 1;
                if(i>63) {
                    i=63;
                    }
                int x = cell[i].get_x();
                int y = cell[i].get_y();
                g_c.set_n(i);
                g_c.set_values(x,y,6);
                g_c.set_color(BLUE);
                g_c.draw_cursor();
                }
                if(myNav.left()){
                int c = cell[g_c.get_n()].get_color();
                g_c.set_color(c);
                g_c.draw_cursor();
                int i = g_c.get_n()- 1;
                if(i<0){
                    i=0;
                    }
                int x = cell[i].get_x();
                int y = cell[i].get_y();
                g_c.set_n(i);
                g_c.set_values(x,y,6);
                g_c.set_color(BLUE);
                g_c.draw_cursor();
                }
                if(myNav.up()){
                int c = cell[g_c.get_n()].get_color();
                g_c.set_color(c);
                g_c.draw_cursor();
                int i = g_c.get_n()- 8;
                if(i<0){
                    i=0;
                    }
                int x = cell[i].get_x();
                int y = cell[i].get_y();
                g_c.set_n(i);
                g_c.set_values(x,y,6);
                g_c.set_color(BLUE);
                g_c.draw_cursor();
                }     
            myled1 = 1;
            myled2 = 0;
            wait(0.2);
            myled1 = 0;
            myled2 =1;
            wait(0.2);

        }
    }
}
