#include "mbed.h"
#include "SRF08.h"
#include "Servo.h"
#include "ID12RFID.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
PwmOut led3(LED3);

SRF08 srf08(p28, p27, 0xE0);      // Define SDA, SCL pin and I2C address
PwmOut meter (p22);
Servo servo (p21);
AnalogIn pot (p18);
ID12RFID rfid (p10);
AnalogIn th (p19);
LocalFileSystem fs ("fs");

int main() {

    FILE *fp = fopen("/fs/hello.txt","w");
    fprintf(fp,"Hello World!\n");
    fclose(fp);

    while (1) {

        // Check to see if an RFID tag has been presented, if so, display it
        if (rfid.readable()) {
            printf("ID Tag : %d\n",rfid.read());
            led1 = !led1;
        }

        // If the middle pot is more than half way 
        // read and display from the Ultrasonic range finder
        if (th.read() > 0.5) {
            float measure = srf08.read();
            printf("Measured range : %.2f cm\n",measure);
            meter = 1.0 - (measure/44.0);
            led2 = !led2;
        }
        
        // Move the servo to reflect the pot
        servo = pot.read();
        led3.write(pot.read());
        wait(0.1);
    }
}