#include "mbed.h"
#include "uLCD_4DGL.h"
#include "tempModule.h"

TempModule::TempModule(PinName pin) : _sensor(pin)
{
    setBaseVx(1.6); setBaseVy(1.2);
}

TempModule::TempModule(PinName pin, float vx, float vy) : _sensor(pin)
{
    setBaseVx(vx); setBaseVy(vy);
}

void TempModule::setBaseVx(float vx) {basevx = vx;}
void TempModule::setBaseVy(float vy) {basevy = vy;}
float TempModule::getVx() {
    float _vx = 0.0; float anaTemp = read();
    _vx = basevx * anaTemp + 2.3;
    return _vx;
}

float TempModule::getVy() {
    float _vy = 0.0; float anaTemp = read();
    _vy = basevy * anaTemp + 1.6;
    return _vy; 
}

float TempModule::getVx(uLCD_4DGL *temp_uLCD) {
    float _vx = 0.0; float anaTemp = read(); float temperature = 0;
    _vx = basevx * anaTemp;
    temperature = ((anaTemp*3.3)-0.500)*100.0;
    temp_uLCD->locate(0,15);
    temp_uLCD->printf("%f", temperature);
    return _vx;
}

float TempModule::read() {
    return _sensor.read();
}