#include "mbed.h"
#include "PinDetect.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "ball.h"
#include "paddle.h"

Serial pc(USBTX, USBRX); // tx, rx
SDFileSystem sd(p5, p6, p7, p8, "sd");
AnalogOut DACout(p18);
wave_player waver(&DACout);

//Seven Segment Display
DigitalOut a(p11);
DigitalOut b(p12);
DigitalOut c(p13);
DigitalOut d(p14);
DigitalOut e(p15);
DigitalOut f(p16);
DigitalOut g(p17);

Ticker sevSegDisplay;

// Pushbuttons
PinDetect pbUp(p23);//p15
PinDetect pbDown(p24);//p16
// uLCD
uLCD_4DGL uLCD(p28, p27, p29);
//Ball
Ball myBall;
//Paddle
Paddle myPaddle;
 
// State machine definitions
enum gameStateType {START, WAIT, GAME_SETUP, GAME, LOSE};
/* State Definitions:
 * START -- Creates the start screen
 * WAIT -- After the start screen, goes into wait where mbed spins and does nothing
 * GAME_SETUP -- Sets up one time things (like boarders, initializes beginning velocity
 * GAME -- When the user actually gets to play
 * LOSE -- clears the screen, prints you lose, waits, then goes back to start
 */
 
// Global state machine variable (So that the pushbuttons can modify it)
gameStateType gameState = START;

void dScore()
{   
    switch(myPaddle.getScore()){
        case 0://Zero digit
            a=0;b=0;c=0;d=0;e=0;f =0;g=1;
            break;        
        case 1://One digit
            b=0;c =0;
            a=1;d=1;e=1;f=1;g = 1;
            break;
        case 2://Two digit
            a=0;b=0;g=0;e=0;d =0;
            f=1;c = 1;
            break;
        case 3://Three digit
            e=1;f =1;
            a=0;b=0;c=0;d=0;g = 0;
            break;
        case 4://Four digit
            f=0;g=0;b=0;c =0;
            a=1;d=1;e = 1;
            break;
        case 5://Five digit
            b=1;e =1;
            a=0;c=0;d=0;f=0;g = 0;
            break;
        case 6://Six digit
            b =1;
            a=0;c=0;d=0;e=0;f=0;g = 0;
            break;
        case 7://Seven digit
            a=0;b=0;c =0;
            d=1;e=1;f=1;g = 1;
            break;
        case 8://Eight digit
            a=0;b=0;c=0;d=0;e=0;f=0;g = 0;
            break;
        case 9://Nine digit
            e=0;d =0;
            a=1;b=1;c=1;f=1;g = 1;
            break;
            }
}

// Pushbutton callbacks
void pbUp_hit_callback (void)
{
    switch (gameState)
    {
    case WAIT:
        gameState = GAME_SETUP;
        break;
    case GAME:  
        myPaddle.movePaddleUp();
        break;
    }
}
 
void pbDown_hit_callback (void)
{
    switch (gameState)
    {
    case WAIT:
        gameState = GAME_SETUP;
        break;
    case GAME:
        myPaddle.movePaddleDown();
        break;
    }
}
 
int main() 
{   
    // This is setting up the pushbuttons
    pbUp.mode(PullUp);
    pbDown.mode(PullUp);
    wait(0.1);
    pbUp.attach_deasserted(&pbUp_hit_callback);
    pbDown.attach_deasserted(&pbDown_hit_callback);
    pbUp.setSampleFrequency();
    pbDown.setSampleFrequency();
 
    uLCD.display_control(PORTRAIT_R);
    uLCD.cls();
    uLCD.baudrate(BAUD_3000000);
    uLCD.background_color(BLACK);
 
    int i = 0;
    sevSegDisplay.attach(&dScore, 0.001);
    
    while (1) 
    {   
        switch (gameState)
        {
        case START:
            gameState = WAIT;
            //Bouncing Ball Demo
            float fx=50.0,fy=21.0,vx=1.3,vy=0.8;
            int x=50,y=21,radius=4;
            uLCD.background_color(BLACK);
            uLCD.cls();
            //draw walls
            uLCD.line(0, 0, 127, 0, WHITE);
            uLCD.line(127, 0, 127, 127, WHITE);
            uLCD.line(127, 127, 0, 127, WHITE);
            uLCD.line(0, 127, 0, 0, WHITE);
            while(gameState == WAIT) {//for (int i=0; i<1500; i++) {
                //draw ball
                uLCD.filled_circle(x, y, radius, RED);
                //bounce off edge walls and slow down a bit?
                if ((x<=radius+1) || (x>=126-radius)) vx = -vx;
                if ((y<=radius+1) || (y>=126-radius)) vy = -vy;
                //erase old ball location
                uLCD.filled_circle(x, y, radius, BLACK);
                //move ball
                fx=fx+vx;
                fy=fy+vy;
                x=(int)fx;
                y=(int)fy;
            }
            break;
        case GAME_SETUP:
            uLCD.cls();
            uLCD.line(0, 0, 127, 0, 0xCFB53B);
            uLCD.line(127, 0, 127, 127, 0xCFB53B);
            uLCD.line(127, 127, 0, 127, 0xCFB53B);
            uLCD.line(0, 127, 0, 0, 0xCFB53B);
            myBall.startPong( i, &uLCD );
            myPaddle.initDraw( &uLCD );
            gameState = GAME;
            break;
        case GAME:
            myBall.testConditions(&myPaddle, &uLCD);
            if (myBall.getLose())
                gameState = LOSE;
            myBall.update( &uLCD );
            myPaddle.redraw( &uLCD );
            break;
        case LOSE:
            uLCD.cls();
            //uLCD.printf("YOU LOSE D:");
            myPaddle.resetScore();
            myBall.setLose(0);
            myBall.resetBall();
            wait(5.0);
            gameState = START;
            break;
        case WAIT:
            // Used to seed the rand() function so we don't get the same starting position every time.
            i++; 
            break;
        }
    }
}