#include "uLCD_4DGL.h"
#ifndef PADDLE_H
#define PADDLE_H

class Paddle 
{
public:
    // Constructors
    Paddle();
    
    // Set Functions
    void setLength(int);
    void setWidth(int);
    void setPaddleMove(int);
    void setScore(int);
    void setX(int);
    void setY(int);
    void setOldY(int);
    
    // Get Function
    int getLength();
    int getWidth();
    int getPaddleMove();
    int getScore();
    int getX();
    int getY();
    int getOldY();
    
    // Member Functions
    void movePaddleUp();
    void movePaddleDown();
    void resetScore(); // sets score to 0
    void initDraw(uLCD_4DGL *uLCD); // draw the paddle initially (draws the whole thing)
    void redraw(uLCD_4DGL *uLCD); // draws the paddle for a move (does NOT draw the whole thing)
    

private:
    int score;
    int x;
    int y;
    int oldy;
    int length;
    int width;
    int paddleMove;
};

#endif
