#include "paddle.h"
#include "uLCD_4DGL.h"

// Constructors
Paddle::Paddle() {
    setLength(40);
    setWidth(3);
    setPaddleMove(8);
    setX(118);//118
    setY(1);
    setOldY(1);
}

/**** Set Functions ****/

void Paddle::setLength(int set_length) {length = set_length; }
void Paddle::setWidth(int set_width) {width = set_width; }
void Paddle::setPaddleMove(int set_pMove){paddleMove = set_pMove; }
void Paddle::setScore(int set_score) {score += set_score; }
void Paddle::setX(int set_x) {x = set_x; }
void Paddle::setY(int set_y) {y = set_y; }
void Paddle::setOldY(int set_oy) {oldy = set_oy; }

/**** Get Functions ****/

int Paddle::getLength() {return length; }
int Paddle::getWidth() {return width; }
int Paddle::getPaddleMove() {return paddleMove; }
int Paddle::getScore() {return score; }
int Paddle::getX() {return x; }
int Paddle::getY() {return y; }
int Paddle::getOldY() {return oldy; }

/**** Member Functions ****/

void Paddle::movePaddleUp() { 
// moves the paddle up (does not draw!)
    if(y > paddleMove)
        y -= paddleMove;
}
void Paddle::movePaddleDown() { 
// moves the paddle up (does not draw!)
    if(y < 127 - paddleMove - length)
        y += paddleMove;
}
void Paddle::resetScore() {score = 0; } // resets score
void Paddle::initDraw(uLCD_4DGL *uLCD) {
// draw the paddle initially (draws the whole thing)
    uLCD->filled_rectangle(x, y, x + width, y + length, BLUE);
}
void Paddle::redraw(uLCD_4DGL *uLCD) {
// draws the paddle for a move (does NOT draw the whole thing)
    if(oldy > y) {
        uLCD->filled_rectangle(x, oldy - paddleMove + 1, x + width, oldy, BLUE);
        uLCD->filled_rectangle(x, oldy + length - paddleMove + 1, x + width, oldy + length, BLACK);
        oldy = y;
    }
    else if(oldy < y) {
        uLCD->filled_rectangle(x, oldy, x + width, oldy + paddleMove, BLACK);
        uLCD->filled_rectangle(x, oldy + length, x + width, oldy + length + paddleMove, BLUE);
        oldy = y;
    }
}// end redraw