#include "mbed.h"
#include "ball.h"
#include "Speaker.h"
#include "uLCD_4DGL.h"
//#include "tempModule.h"

Speaker mySpeaker(p26);//Must be PWM pin or runtime error will occur

/**** Constructors ****/

Ball::Ball() {
    setXSign(-1); setYSign(0);
    setFx(0); setFy(0);
    setVx(1.6); setVy(1.2);
    setX(0); setY(0);
    setRadius(5);
}

Ball::Ball(PinName pin)
{
    setXSign(-1); setYSign(0);
    setFx(0.0); setFy(0.0);
    setVx(1.6); setVy(1.2);
    setX(0); setY(0);
    setRadius(5);
    tempSensor = new TempModule(pin);
}

Ball::Ball(PinName pin, float vx, float vy)
{
    setXSign(-1); setYSign(0);
    setFx(0.0); setFy(0.0);
    setVx(vx); setVy(vy);
    setX(0); setY(0);
    setRadius(5);
    tempSensor = new TempModule(pin);
}

/**** Set Functions ****/

// This sets the lowest velocity, for Thermal pong, or the constant velocity of x
void Ball::setVx(float set_vx) {vx = set_vx; }
// This sets the lowest velocity, for Thermal pong, or the constant velocity of y
void Ball::setVy(float set_vy) {vy = set_vy; }
void Ball::setXSign(int set_xSign) {xSign = set_xSign; } 
void Ball::setYSign(int set_ySign) {ySign = set_ySign; }
void Ball::setRadius(int set_radius) {radius = set_radius; }
void Ball::setFx(float set_fx) {fx = set_fx; }
void Ball::setFy(float set_fy) {fy = set_fy; }
void Ball::setX(int set_x) {x = set_x; }
void Ball::setY(int set_y) {y = set_y; }
void Ball::setLose(bool set_lose) {lose = set_lose; }

/**** Get Functions ****/

int Ball::getFutureX() {
// calculate new X position
    int xTemp;
    xTemp = getFx() + ( getXSign() * getVx() );
    return xTemp;
}

int Ball::getFutureY() {
// calculate new Y position
    int yTemp;
    yTemp = getFy() + ( getYSign() * getVy() );
    return yTemp;
}

int Ball::getRadius() {return radius;}
int Ball::getXSign() {return xSign;}
int Ball::getYSign() {return ySign;}
int Ball::getX() {return x;}
int Ball::getY() {return y;}
float Ball::getFx() {return fx;}
float Ball::getFy() {return fy;}
float Ball::getVx() {return vx;}
float Ball::getVy() {return vy;}
bool Ball::getLose() {return lose;}

/**** Member Functions ****/

void Ball::reverseXDirection() {
// negate the sign when ball hits wall or paddle
    int xTemp;
    xTemp = getXSign();
    setXSign(-xTemp);
}

void Ball::reverseYDirection() {
// negate the sign when ball hits wall or paddle
    int yTemp;
    yTemp = getYSign();
    setYSign(-yTemp);
}

void Ball::startPong(int count, uLCD_4DGL *my_uLCD) {
// initialize starting pointion for the ball
    int rnd = 0;
    srand(count);
    rnd = (rand() % (118 - 2 * getRadius())) + getRadius();
    setFx( rnd ); setX( rnd );
    rnd = (rand() % (127 - 2 * getRadius())) + getRadius();
    setFy( rnd ); setY( rnd );
    rnd = rand() % 2;
    setYSign( ((float)rnd - 0.5) * 2 );
}

void Ball::update(uLCD_4DGL *update_uLCD) {
// moves the ball on the screen
    update_uLCD->filled_circle(getX(), getY(), getRadius(), BLACK);
    setFx(getFx()+(getXSign() * (1.5*getVx())));
    setFy(getFy()+(getYSign() * (1.5*getVy())));
    setX(getFutureX());
    setY(getFutureY());
    update_uLCD->filled_circle(getX(), getY(), getRadius(), WHITE);
    
}

void Ball::resetBall() {
// resets ball location for new game
    setVx(1.6); setVy(1.2);
}

void Ball::testConditions( Paddle *my_paddle, uLCD_4DGL *my_uLCD ) {
    if ((getFx()+getXSign() * getVx() <= getRadius()+3))
    {
        mySpeaker.PlayNote(300.0, 0.05, 0.1);
        reverseXDirection();    
    }
    if ((getFy()+getYSign() * getVy() <= getRadius()+3) || (getFy()+getYSign() * getVy() >= 125-getRadius()))
    {
        mySpeaker.PlayNote(300.0, 0.05, 0.1);
        reverseYDirection();
    }
    if (((getFx()+getXSign() * getVx() >= my_paddle->getX()) && (getFx()+getXSign() * getVx() <= my_paddle->getX()+3)) &&
        ((getFy()+getYSign() * getVy() >= my_paddle->getY()) && (getFy()+getYSign() * getVy() <= my_paddle->getY()+my_paddle->getLength())))
    {
        mySpeaker.PlayNote(300.0, 0.05, 0.1);
        reverseYDirection();
    }
    if ((getFx()+getXSign() * getVx() >= 123-getRadius()))
    {
        mySpeaker.PlayNote(300.0, 0.7, 0.3);
        setVx(0);
        setVy(0);
        setLose(1);
    }
    if ((getFx()+getXSign() * getVx() >= my_paddle->getX()-(getRadius()+2.5)) && (getFy()+getYSign() * getVy() <= my_paddle->getY()+my_paddle->getLength())
         && (getFy()+getYSign() * getVy() >= my_paddle->getY())) 
    {
        mySpeaker.PlayNote(400.0, 0.05, 0.1);
        reverseXDirection();
        my_paddle->setScore(1);
        
/*      my_uLCD->locate(1,1);
        my_uLCD->printf("%d", my_paddle->getScore());
*/        
    }
}

