#ifndef TEMPMODULE_H
#define TEMPMODULE_H
#include "mbed.h"
#include "uLCD_4DGL.h"

class TempModule 
{
public:
    // Constructors
    TempModule(PinName pin);
    TempModule(PinName pin, float vx, float vy);
    // Reading temperature values
    float read();
    // Set Functions
    void setBaseVx(float); // This sets the lowest velocity of vx
    void setBaseVy(float); // This sets the lowest velocity of vy
    // Get Functions/Member Functions
    float getVx();  // Calculates a speed based off of the temp
    float getVy();   
    float getVx(uLCD_4DGL *); // Same thing as getVx(), except it 
                              // also writes the temp to the screen.

private:
    // Data members are suggestions, feel free to add/remove
    AnalogIn _sensor;
    float roomTemp;
    float holdTemp;
    float basevx;
    float basevy;
    int counter;
};
#endif