#include "tempModule.h"
#include "uLCD_4DGL.h"
#include "paddle.h"

class Ball
{
public: 
   
    // Constructors
    
    Ball();
    Ball(PinName);
    Ball(PinName,float, float);

    // Set Functions
    void setVx(float);// This sets the lowest velocity, for Thermal pong, or the constant velocity of x
    void setVy(float);// This sets the lowest velocity, for Thermal pong, or the constant velocity of y
    void setXSign(int); 
    void setYSign(int);
    void setRadius(int);
    void setFx(float);
    void setFy(float);
    void setX(int);
    void setY(int);
    void setLose(bool);

    // Get Functions
    int getFutureX();// calculate new X position
    int getFutureY();// calculate new Y position
    int getXSign();
    int getYSign();
    int getRadius();
    int getX();
    int getY();
    float getFx();
    float getFy();
    float getVx();
    float getVy();
    bool getLose();

    // Member Functions
    void reverseXDirection();// negate the sign when ball hits wall or paddle
    void reverseYDirection();// negate the sign when ball hits wall or paddle
    void startPong(int, uLCD_4DGL *);// initialize starting pointion for the ball
    void update(uLCD_4DGL *);// moves the ball on the screen
    void resetBall();
    void testConditions(Paddle *,uLCD_4DGL *); 
    
private:
    TempModule *tempSensor;
    int xSign;
    int ySign;
    float fx;
    float fy;
    float vx;
    float vy;
    int x;
    int y;
    int radius;
    bool lose;
};