#ifndef DEBIMETER_H
#define DEBIMETER_H

#include <mbed.h>
#include "Global.h"
#include "Adafruit_ADS1015.h"


extern I2C i2c;
extern Adafruit_ADS1015 ads;



//Class Debimeter
class Debimeter{
    

public:
    Debimeter(Reactif reactif_,float debitMax_,Enum_UnitFlow unit_,int voie_adc_);
    //lit la valeur de débit
    float get_volt(void);
    void set_unit(Enum_UnitFlow unity);
    string get_text_unit(void);
    void set_typereactif(Reactif reactif) ;
    Reactif get_typereactif(void);
    void set_channel(int channel);
    float get_debit_NL(void);
    float get_debit_m(void);
    float get_debit_unit(void);


    //attributs
private:
    Reactif m_reactif;
    float m_debitMax;

    Enum_UnitFlow m_unit;
    float m_tensionadc;
    int m_voie_adc;



};
#endif