#include <mbed.h>
#include "Debimeter.h"
I2C i2c(PTE25,PTE24); // sda scl
Adafruit_ADS1015 ads(&i2c);



//channel I2C ADS1015
//Constructeur
Debimeter::Debimeter(Reactif reactif_,float debitMax_,Enum_UnitFlow unit_,int voie_adc_) : m_reactif(reactif_),m_debitMax(debitMax_),
    m_unit(unit_), m_tensionadc(0.0f),m_voie_adc(voie_adc_)
{

}



//lit la valeur de débit

float Debimeter::get_volt(void) 
{
    m_tensionadc=ads.readADC_SingleEnded(m_voie_adc);
    m_tensionadc=m_tensionadc*0.003f;
    return m_tensionadc;


}

//change l'unité du débimètre
void Debimeter::set_unit(Enum_UnitFlow unity)
{
    m_unit=unity;
}
string Debimeter::get_text_unit(void)
{ string TextUnit;
    TextUnit=TextUnitFlow[m_unit];
    return TextUnit;
}



//change le type de réactif
void Debimeter::set_typereactif(Reactif reactif)//carburant ou comburant
{
    m_reactif=reactif;
}

//retourne le type de réactif
Reactif Debimeter::get_typereactif(void)//carburant ou comburant
{
    return m_reactif;
}


//Affecte la voie ADC de l'ADS1015 de 0 à 3

void Debimeter::set_channel(int channel)
{
    m_voie_adc=channel;
}

// retourne le débit dans l'unité réglée d'origine
float Debimeter::get_debit_NL(void) 
{   float debit_NL;
    debit_NL=get_volt()*m_debitMax/5.0f;
    return debit_NL;
}

float Debimeter::get_debit_m(void) //alias débit massqiue
{   float debit_m;
    float n_mol,masse_mol;
    // rappel : typedef enum { C12H26, C2H4, C3H8, C7H16, CH4} Fue; et fuel est du type Fue
    float Mcarb[5]={170.3348f,28.0532f,44.0956f,100.2019f,16.0425f};
    n_mol=get_debit_NL()*101.3f/(8.314f*273.15f);
    if(m_reactif==comburant) 
        masse_mol=29.0f;
        else{
            masse_mol=Mcarb[fuel];
            if((fuel != C12H26) && (fuel != C7H16)) //=> conditions pour avoir un carburant gazeux
            wait(0.001);
            else //si carburant liquide : on passe à la conversion débit massique-> molaire, directement
            n_mol=get_debit_NL()/Mcarb[fuel];
            }
    debit_m=n_mol*masse_mol;
    return debit_m;
    
    }

float Debimeter::get_debit_unit(void) //débit de l'unité notifier dans les arguments de l'objet créé
{   float debit_unit;

    debit_unit=get_volt()*m_debitMax/5.0f;
    return debit_unit; //ToDo : rajouter un tableau de coeficient d'unité
    
}