//Daniel Begasse
//Keith Ng
//This is our ECE 4180 Final Project
//We use the uLCD, MPR121 Capacitive Touch Pad, XBee, and a pushbutton to send text messages between two identical breadboards

#include "mbed.h"
#include "uLCD_4DGL.h"
#include <stdio.h>
#include <stdlib.h>
#include <mpr121.h>
#include <iostream>
#include <string>

using namespace std;

//Set up the interrupt pin
InterruptIn interrupt(p26);

// Setup the i2c bus on pins 9 and 10
I2C i2c(p9, p10);

// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

//create a global lcd project
uLCD_4DGL uLCD(p28, p27, p30); 

// Setup the Serial to the PC for debugging
Serial pc(USBTX, USBRX);

//Set up XBee
Serial xbee(p13, p14);
DigitalOut rst1(p11);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalIn send(p21);

volatile bool tripped = false;
volatile bool validkey;//This represents if the key pressed was a valid key
volatile int oldpressed;//This is the previous key that was pressed
volatile int value;//This is the value coming in from the register
volatile int pressed;//This is the current key being pressed
volatile int pressedcount = 0;//This is how many times the current key has been repeatedly pressed
int cursor_row = 13;
int cursor_col = 0;
int read_row = 0;
int read_col = 0;
string message_send = "-                  ";
string message_receive = "                    ";
int char_count = 0;//This is the number of times the space button has been pressed for the current message
unsigned size; 
int received_count = 0;

bool sent = false;

char key_1[1] = {'1'};
char key_2[4] = {'a','b','c','2'};
char key_3[4] = {'d','e','f','3'};
char key_4[4] = {'g','h','i','4'};
char key_5[4] = {'j','k','l','5'};
char key_6[4] = {'m','n','o','6'};
char key_7[5] = {'p','q','r','s','7'};
char key_8[4] = {'t','u','v','8'};
char key_9[5] = {'w','x','y','z','9'};
char key_10[1] = {' '};

void fallInterrupt() {
    
    validkey = false;//Each key pressed is invalid until proven to be valid 
    value = mpr121.read(0x00);
    value += mpr121.read(0x01)<<8;
    
    //Take the value from the register and use it to assign a key #
    switch(value){
        
        case (0x1):
            pressed = 10;
            validkey = true;
            break;
        case (0x10):
            pressed = 11;
            validkey = true;
            break;
        case (0x100):
            pressed = 12;
            validkey = true;
            break;
        case (0x2):
            pressed = 7;
            validkey = true;
            break;
        case (0x20):
            pressed = 8;
            validkey = true;
            break;
        case (0x200):
            pressed = 9;
            validkey = true;
            break;
        case (0x4):
            pressed = 4;
            validkey = true;
            break;
        case (0x40):
            pressed = 5;
            validkey = true;
            break;
        case (0x400):
            pressed = 6;
            validkey = true;
            break;
        case (0x8): 
            pressed = 1;
            validkey = true;
            break;
        case (0x80):
            pressed = 2;
            validkey = true;
            break;
        case (0x800):
            pressed = 3;
            validkey = true;
            break;
        default:
            validkey = false;
            break;
    }
    
    //If the two values are different, assign pressed to oldpressed
    if ((pressed != oldpressed) && (validkey == true) ){

        oldpressed = pressed;
        pressedcount = 0;
        char_count++;//move the cursor over if there is a new key
    }
    
    else if ((pressed == oldpressed) && (value != 0)) {
        
        pressedcount++;    
    }
}

void checkCharacter(){
        if (pressed == 1){
            if (pressedcount > 0){
                pressedcount = 0;
            } 
            message_send[char_count] = '1';
        }
        
        if (pressed == 2){    
            if (pressedcount > 3){
                pressedcount = 0;
            }
            message_send[char_count] = key_2[pressedcount];
        }
            
        if (pressed == 3){
            if (pressedcount > 3){
                pressedcount = 0;
            } 
            message_send[char_count] = key_3[pressedcount];
        }
        
        if (pressed == 4){
            if (pressedcount > 3){
                pressedcount = 0;
            } 
            message_send[char_count] = key_4[pressedcount];
        }
        
        if (pressed == 5){
            if (pressedcount > 3){
                pressedcount = 0;
            }
            message_send[char_count] = key_5[pressedcount];
        }
        
        if (pressed == 6){
            if (pressedcount > 3){
                pressedcount = 0;
            } 
            message_send[char_count] = key_6[pressedcount];
        }
        
        if (pressed == 7){
            if (pressedcount > 4){
                pressedcount = 0;
            } 
            message_send[char_count] = key_7[pressedcount];
        }
        
        if (pressed == 8){
            if (pressedcount > 3){
                pressedcount = 0;
            } 
            message_send[char_count] = key_8[pressedcount];
        }
        
        if (pressed == 9){
            if (pressedcount > 4){
                pressedcount = 0;
            } 
            message_send[char_count] = key_9[pressedcount];
        }
    
        if (pressed == 10) {        
            message_send[char_count] = ' ';
        }
        if (pressed == 11) {       
            if (pressedcount > 0){
                pressedcount = 0;
            }  
            message_send[char_count] = '0';
        }
}

void printMessage(){
    
    uLCD.locate(cursor_col, cursor_row);
    
    //This will print the current message being typed towards the bottom of the lcd screen
    for ( unsigned i = 0; i <= char_count; i++ ){
        
        uLCD.printf("%c", message_send[i]);
    }
    
    //If the message was just sent, 
    if ( sent == true ){
        
        uLCD.locate(0, cursor_row);
        
        for ( unsigned i = 1; i <= char_count+1; i++ ){
        
            message_send[i] = ' ';//Overwrite all of the spots in the string with  a space
            uLCD.printf("%c", message_send[i]);
        }
        char_count = 0;
    }
}

void write(){
    
    char chartosend;
          
    for ( unsigned i = 0; i <= char_count; i++ ){
        
        //Go through each char of message and send the char's 1 by 1 through the xbee       
        chartosend = message_send[i];        
        xbee.printf("%c", chartosend);
    
        wait(0.01);
        led2 = 1;
        wait(0.01);
        led2 = 0;
    }
}

void read(){
    
    char fromXBee;
    
    //led3 = 1;
    //wait(0.2);
    
    
    if(xbee.readable()) {
        
        uLCD.locate(received_count, read_row);
        
        led4 = 1;
        wait(0.2);
        
        fromXBee = xbee.getc(); //Get individual characters being sent by other xbee
        message_receive[received_count] = fromXBee;
        uLCD.printf("%c", message_receive[received_count]);
        
        received_count++;
        
        read();
        
        led4 = 0; 
        //wait(0.2);
        
        }
    
    //led3 = 0;
    //wait(0.2);
    
}
  
int main(){
    
    rst1 = 0; 
    wait_ms(1);
    rst1 = 1;  
    wait_ms(1);
    
    pc.baud(9600);
    
    send.mode(PullUp);
    interrupt.mode(PullUp);
    wait(.001);
    interrupt.fall(&fallInterrupt);
    
    while(1){
        
        checkCharacter();
        printMessage();
        
        sent = false;
        
        if ( send == 0 ){
        
            led2 = 1;
            write();
            sent = true; 
            pressed = 0;
            validkey = false;
        }
        
        read();
        
        if (sent == true){
            
            read_row++;
            received_count = 0;
            
        }
       
    }   
}