//Daniel Begasse
//Kieth Nga
//ECE 4180 Lab 4
//This game uses reading from the accelerometer on an IMU sensor to move a ball through a maze
//The goal of the game is to move to yellow ball through the maze, avoiding walls and obstacles along the way

#include "LSM9DS0.h"
#include "mbed.h"
#include "uLCD_4DGL.h"
#include <stdio.h>
#include <stdlib.h>

// SDO_XM and SDO_G are both grounded, so our addresses are:
#define LSM9DS0_XM  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G   0x6B // Would be 0x6A if SDO_G is LOW


LSM9DS0 dof(p9, p10,LSM9DS0_G, LSM9DS0_XM);
uLCD_4DGL uLCD(p28, p27, p30); //create a global lcd project
Serial pc(USBTX, USBRX); // tx, rx

#define PRINT_CALCULATED
#define PRINT_SPEED 500 // 500 ms between prints

//Init Serial port and LSM9DS0 chip
void setup()
{
    pc.baud(9600);//Had to update the baud rate to match tera term
    uint16_t status = dof.begin();
    
}



void drawMaze(){
    
    uLCD.filled_rectangle(20, 0, 23, 40 , 0x00FF00); //Wall 1
    uLCD.filled_rectangle(0, 105, 40, 108 , 0x00FF00); //Wall 2
    uLCD.filled_rectangle(25, 70, 127, 73 , 0x00FF00); //Wall 3
    uLCD.filled_rectangle(45, 40, 48, 70 , 0x00FF00); //Wall 4
    uLCD.filled_rectangle(45, 40, 75, 43 , 0x00FF00); //Wall 5
    uLCD.filled_rectangle(75, 73, 78, 108 , 0x00FF00); //Wall 6
    uLCD.filled_rectangle(90, 15, 127, 18 , 0x00FF00); //Wall 7
    uLCD.filled_circle(100, 100, 5, BLUE);//End destination
    uLCD.filled_circle(100, 50, 7, DGREY); //Hole #1
    uLCD.filled_circle(60, 90, 7, DGREY); //Hole #2
        
}

void displayRules(){
    
    uLCD.printf(" Labyrinth Danger!\n\n\n");
    wait(3);
    uLCD.locate(5,3);
    uLCD.printf("THE RULES\n");
    wait(1.5);
    uLCD.printf("1.)Avoid the walls\n");
    wait(1.5);
    uLCD.printf("2.)Avoid the holes\n");
    wait(1.5);
    uLCD.printf("3.)Get the yellow ball in the blue hole to win");
    wait(6); 
    uLCD.cls();
    
    }

void youLose(){
    
    uLCD.cls();
    uLCD.locate(1,4);
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.printf("YOU LOSE\n");
    }

void youWin(){
    
    uLCD.cls();
    uLCD.locate(1,4);
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.printf("YOU WIN!\n");
    }

int main()
{
    displayRules();//Show the rules before the start of the game
    setup();  //Setup sensor and Serial
    drawMaze(); //Draw the maze

    int circlex = 0;
    int circley = 0;
    int circler = 3;
    int last_circlex = 64;
    int last_circley = 64; 
    float accelx;
    float accely;
         

    
    while (true)
    {

         dof.readAccel();
         accelx = dof.calcAccel(dof.ax) - dof.abias[0];
         accely = dof.calcAccel(dof.ay) - dof.abias[1];
         //pc.printf("%2f\n", accel);
         wait(0.05);
         
            
         //Get rid of the old circle
         uLCD.filled_circle(last_circlex, last_circley, circler, BLACK);
         
         circlex = 128 - ((1 + accelx) * 64);
         circley = (1 + accely) * 64;
         
         
         //This checks if the game has been won
         if( (circlex >= 96 && circlex <= 104) && (circley >= 96 && circley <= 104) ){
             
             youWin();
             break;
             }
             

        //This checks if the ball has hit wall number 1
        if( (circlex >= 18 && circlex <= 25) && (circley >= 0 && circley <=42) ){
             
             youLose();
             break;
             }
        //This checks if the ball has hit wall number 2
        if( (circlex >= 0 && circlex <= 42) && (circley >= 103 && circley <= 110) ){
             
             youLose();
             break;
             }
         
         //This checks if the ball has hit wall number 3
         if( (circlex >= 23 && circlex <= 129) && (circley >= 68 && circley <=75) ){
             
             youLose();
             break;
             }
             
        //This checks if the ball has hit wall number 4
        if( (circlex >= 43 && circlex <= 50) && (circley >= 38 && circley <= 72) ){
             
             youLose();
             break;
             }
             
        //This checks if the ball has hit wall number 5
        if( (circlex >= 43 && circlex <= 77) && (circley >= 38 && circley <= 45) ){
             
             youLose();
             break;
             }
        
        //This checks if the ball has hit wall number 6
        if( (circlex >= 73 && circlex <= 80) && (circley >= 72 && circley <= 110) ){
             
             youLose();
             break;
             }
             
             //This checks if the ball has hit wall number 7
        if( (circlex >= 88 && circlex <= 129) && (circley >= 13 && circley <= 20) ){
             
             youLose();
             break;
             }
        
        //This checks if the ball fell into hole #1
         if( (circlex >= 95 && circlex <= 105) && (circley >= 45 && circley <= 55) ){
             
             youLose();
             break;
             }
             
        //This checks if the ball fell into hole #2
         if( (circlex >= 55 && circlex <= 65) && (circley >= 85 && circley <= 95) ){
             
             youLose();
             break;
             }
             
        //If the player has not won or hit a wall, update the location of the ball 
        else{
         
         last_circlex = circlex;
         last_circley = circley;
         uLCD.filled_circle(circlex, circley, circler, 0xFFFF00);
        }
        
   }
   

}

