//==================================
//
// VEX MOTOR CONTROL EXAMPLE PROGRAM
//   ----------------------------
// Controls a PWM VEX motor speed 
// with the "u" and "d" keys 
//
//==================================

//==================================
// Add any libraries that you use:
//==================================

#include "mbed.h"
#include "Servo.h"


//==================================
// Add variables:
//==================================


//add a servo to PWM output on pin 21

Servo myservo(p21);

//add a variable for motor speed
//0.0 is full counter-clockwise
//0.5 is zero rpm
//1.0 is full clockwise

float speed = 0.5;

//add variables for the 4 onboard LEDS
PwmOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

//PC USB link
Serial pc(USBTX, USBRX);


//==========================================================
//  MAIN FUNCTION
//  waits for button press, then uses the button code above
//==========================================================

int main() {

//prompt the PC user for differential speed value

    pc.printf("Control of servo speed by host terminal\n\r"); 
    pc.printf("Press 'u' = brighter, 'd' = dimmer\n\r");

    while(1) {

//get the value for speed

        char c = pc.getc();
        wait(0.001);
        
//up logic
        
        if((c == 'u') && (speed < 0.99)) {
            speed += 0.01;
            myservo = speed;
            led1 = speed;
        }

//down logic
    
        if((c == 'd') && (speed > 0.0)) {
            speed -= 0.01;
            myservo = speed;
            led1 = speed;
        } 
 
//display the speed to the PC   

        pc.printf("%c %1.3f \n \r",c,speed); 
    
    }

//end while loop

}

//end of main function
