//=======================================|
//%|==================================|%%|
//%|                                  |%%|
//%|          PLTW PROGRAM            |%%|
//%|   ----------------------------   |%%|
//%|  Controls a PWM output using     |%%|
//%|  digital inputs                  |%%|
//%|                                  |%%|
//%|  MOTOR SPEED:                    |%%|
//%|   0.00 - 0.49 reverse            |%%|
//%|   0.49 - 0.51 zero               |%%| 
//%|   0.51 - 1.00 forward            |%%|
//%|                                  |%%|
//%|==================================|%%|
//=======================================|

//==================================
// Add any libraries that you use:
//==================================

#include "mbed.h"
#include "Servo.h"


//==================================
// Add variables:
//==================================

//add a motor to PWM output on pin 25
Servo motor1(p25);

//add a variable for motor speed
float speed = 0.5;

//add variables for the onboard LEDS, which display for each button
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

//add variables for button inputs on pins 15, 16, 17, and 18.
InterruptIn a(p18), b(p17), c(p16), d(p15);

//add variable for button press     //=========================================== NEW
int apress = 0;                     //=========================================== NEW

//==================================
// Functions for each button press
//==================================


// Functions for button 1
void a_hit_interrupt (void) {

    if(apress == 0){                    // PRESSING A WILL DO NOTHING AFTER THE FIRST PRESS
                                        // UNLESS THE B BUTTON HAS BEEN PRESSED
        //set the apress variable to 1  // SET APRESS VARIABLE TO 1
        apress = 1;                     // SET APRESS VARIABLE TO 1
        
        //move VEX motor (1 is full CCW, 0 is full CW)
        speed = 1.0;
        motor1 = speed;
        //set the motor on duration in seconds:
        wait(1);
        //stop motor
        speed = 0.5;
        motor1 = speed;
    
        //Set LED 1
        led1 = 1, led2 = 0, led3 = 0, led4 = 0;
    }
}
 
 
 
// Functions for button 2
void b_hit_interrupt (void) {
    if(apress == 1){                // PRESSING B WILL DO NOTHING IF A HAS NOT PRESSED
    
        //set the apress variable to 1  // RESET APRESS VARIABLE TO 0
        apress = 0;                     // RESET APRESS VARIABLE TO 0

    //move VEX motor (1 is full CCW, 0 is full CW)
    speed = 0.0;
    motor1 = speed;
    //set the motor on duration in seconds:
    wait(1);
    //stop motor
    speed = 0.5;
    motor1 = speed;
    
    //Set LED 2
    led1 = 0, led2 = 1, led3 = 0, led4 = 0;    
    }
}



// Functions for button 3 
void c_hit_interrupt (void) {

    //Set LED 3
    led1 = 0, led2 = 0, led3 = 1, led4 = 0;
}
 
 
 
// Functions for button 4 
void d_hit_interrupt (void) {

    //Set LED 4
    led1 = 0, led2 = 0, led3 = 0, led4 = 1;
}



//==========================================================
//  MAIN FUNCTION
//  waits for button press, then uses the button code above
//==========================================================

int main() {
       
    // Use internal pullup resistors to limit the signal current
    a.mode(PullUp);
    b.mode(PullUp);
    c.mode(PullUp);
    d.mode(PullUp);            
    
    // Delay for initial pullup switching to take effect
    wait(.01);
    
    // tells the code what function should be called for each switch press
    a.fall(&a_hit_interrupt);
    b.fall(&b_hit_interrupt);
    c.fall(&c_hit_interrupt);
    d.fall(&d_hit_interrupt);
    
    
    while(1) {
        //reset LEDs
        led1 = 0, led2 = 0, led3 = 0, led4 = 0;

    }
}
