#include "mbed.h"
#include "Servo.h"
 
Servo myservo(D3);
Serial pc(USBTX, USBRX);
 
int main() {
    pc.baud(115200);
    pc.printf("Servo Calibration Controls:\n");
    pc.printf("1,2,3 - Position Servo (full left, middle, full right)\n");
    pc.printf("4,5 - Decrease or Increase range\n");
 
    float range = 0.0005*2;
    float position = 0.5;
    
    while(1) {                   
        switch(pc.getc()) {
            case '1': position = 0.0; break;
            case '2': position = 0.5; break;
            case '3': position = 1.0; break;
            case '4': position = 0.65; break;
            case '5': position += 0.01; break; 
            case '6': position -= 0.01; break; 
        }
        printf("position = %.1f, range = +/-%0.4f\n", position, range);
        myservo.calibrate(range, 45.0); 
        myservo = position;
    }
}